/***************************************************************************
                          kcontrolheader.h  -  description
                             -------------------
    begin                : Tue May 29 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONTROLHEADER_H
#define KCONTROLHEADER_H

#include "fileread.h"
#include "klangcombo.h"

#include <qwidget.h>
#include <kdialogbase.h>
#include <kcombobox.h>
#include <kurlrequester.h>

#include <qlineedit.h>
#include <qstringlist.h>

/**Information header
  *@author Javier Campos
  */

class kcontrolheader : public KDialogBase  {
   Q_OBJECT
public: 
	kcontrolheader(FileRead *KEDUCAPTR, QWidget *parent=0, const char *name=0);
	~kcontrolheader();
private: // Private attributes
  /** Keduca pointer */
  FileRead *KEDUCA;
  /** Title */
  QLineEdit *header_title;
  /** Header type */
  KComboBox *header_type;
  /** Header category */
  KComboBox *header_category;
  /** Header level */
  KComboBox *header_level;
  /** Header lang */
  KLanguageCombo *header_lang;
  /** Header picture */
  KURLRequester *header_picture;
  /** Header name */
  QLineEdit *header_name;
  /** Header email */
  QLineEdit *header_email;
  /** Header www */
  QLineEdit *header_www;
  /** Default categories */
  QStringList DefaultCategories;
private: // Private methods
  /** Init graphical interface */
  void init();
  /** Insert header */
  void insertHeader();
  /** Load country list */
  void loadCountryList(KLanguageCombo *combo);
  /** Write settings */
  void configWrite();
  /** Read settings */
  void configRead();
private slots: // Private slots
  /** Ok push */
  void slotOk();
};

#endif
