/***************************************************************************
                            KURLDrag.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KURLDRAG_H
#define KURLDRAG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QUriDrag.h>

/**

 This class is to be used instead of QUriDrag when using KURL.
 The reason is : QUriDrag (and the XDND/W3C standards) expect URLs to
 be encoded in UTF-8 (unicode), but KURL uses the current locale
 by default.
 The other reasons for using this class are:
 - it exports text/plain (for dropping/pasting into lineedits, mails etc.)
 - it has support for metadata, shipped as part of the dragobject
 This is important, for instance to set a correct HTTP referrer (some websites
 require it for downloading e.g. an image).

 To create a drag object, use -[KURLDrag newDrag]with a list of KURLs.
 To decode a drop, use -[KURLDrag decode]or -[QUriDrag decodeLocalFiles].
 
 @short 
 This class is to be used instead of QUriDrag when using KURL.
*/
@interface KURLDrag : QUriDrag 

/** 
 Constructs an object to drag the list of URLs in @p urls.
 The @p dragSource and @p name arguments are passed on to QUriDrag,
 and the list of urls is converted to UTF-8 before being passed
 to QUriDrag.
   
*/
- initWithArray: (NSArray *)urls dragSource: (QWidget *)dragSource name: (NSString *)name;
- (void) dealloc;

/** 

   
*/
+ (KURLDrag*) newDrag: (NSArray *)urls dragSource: (QWidget *)dragSource name: (NSString *)name;
+ (KURLDrag*) newDrag: (NSArray *)urls ;

/** 
 Convenience method that decodes the contents of @p e
 into a list of KURLs.
   
*/
//+ (BOOL) decode: (QMimeSource*)e urls: (NSArray *)urls;

/** 
 Convenience method that decodes the contents of @p e
 into a list of KURLs for Qt versions without a MIME clipboard.
   
*/
//+ (BOOL) decode: (NSArray *)e uris: (NSArray *)uris;
//- (NSString *) format: (int)i;
//- (QByteArray*) encodedData: (NSString *)mime;
@end

/** Override these methods in subclasses of KURLDrag to customise event handling behaviour */
@protocol KURLDragEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
