package org.kde.koala;
import org.kde.qt.*;
import java.io.ByteArrayOutputStream;


/** {@link TransferJob} emits these signals */
public interface TransferJobSignals {

/** 
 Emitted when the slave successfully connected to the host.
 There is no guarantee the slave will send this, and this is
 currently unused (in the applications).
         
*/
	void connected( Job arg1 );
	void destroyed( QObject obj );

/** 
 Emitted to display information about this job, as sent by the slave.
 Examples of message are "Resolving host", "Connecting to host...", etc.
         
*/
	void infoMessage( Job arg1, String msg );

/** 

 Emitted if the "put" job found an existing partial file
 (in which case offset is the size of that file)
 and emitted by the "get" job if it supports resuming to
 the given offset - in this case <code>offset</code> is unused)
         
*/
	void canResume( Job arg1, int offset );

/** 
 Data from the slave has arrived.

*/
	void data( Job arg1, byte[] data );

/** 
 Request for data.

*/
	void dataReq( Job arg1, ByteArrayOutputStream data );

/** 
 Regularly emitted to show the progress of this job
 (current data size for transfers, entries listed).
         
*/
	void processedSize( Job arg1, int size );

/** 
 Emitted when the job is finished, in any case (completed, canceled,
 failed...). Use {@link error} to know the result.
         
*/
	void result( Job job );

/** 
 Emitted when the job is canceled.

 Signal <code>result</code> is emitted as well, and error() is,
 in this case, ERR_USER_CANCELED.
         
*/
	void canceled( Job job );

/** 
 Signals a redirection.
 Use to update the URL shown to the user.
 The redirection itself is handled internally.
         
*/
	void redirection( Job arg1, KURL url );

/** 
 Emitted when we know the size of this job (data size for transfers,
 number of entries for listings).
         
*/
	void totalSize( Job arg1, int size );

/** 
 Progress signal showing the overall progress of the job
 This is valid for any kind of job, and allows using a
 a progress bar very easily. (see {@link KProgress})
         
*/
	void percent( Job job, long percent );

/** 
 Emitted to display information about the speed of this job.
         
*/
	void speed( Job arg1, long bytes_per_second );

/** 
 Mimetype determined
         
*/
	void mimetype( Job arg1, String type );
}

