/***************************************************************************
                            KHTMLView.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Renders and displays HTML in a {@link QScrollView}.

 Suitable for use as an application's main view.

 See {@link KHTMLViewSignals} for signals emitted by KHTMLView.

 See {@link KHTMLViewEventHandling} for event handlers to override in subclasses of KHTMLView.

 @short 
 Renders and displays HTML in a @ref QScrollView.
*/
public class KHTMLView extends QScrollView  {
	protected KHTMLView(Class dummy){super((Class) null);}

	private native void newKHTMLView( KHTMLPart part, QWidget parent, String name);

/** 
 Constructs a KHTMLView.
     
*/
	public KHTMLView( KHTMLPart part, QWidget parent, String name) {
		super((Class) null);
		newKHTMLView( part, parent, name);
	}
	private native void newKHTMLView( KHTMLPart part, QWidget parent);
	public KHTMLView( KHTMLPart part, QWidget parent) {
		super((Class) null);
		newKHTMLView( part, parent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns a pointer to the KHTMLPart that is
 rendering the page.

*/
	public native KHTMLPart part();
	public native int frameWidth();

/** 
 Sets a margin in x direction.
     
*/
	public native void setMarginWidth( int x);

/** 
 Returns the margin width.

 A return value of -1 means the default value will be used.
     
*/
	public native int marginWidth();
	public native void setMarginHeight( int y);

/** 
 Returns the margin height.

 A return value of -1 means the default value will be used.
     
*/
	public native int marginHeight();

/** 
 Sets verticals scrollbar mode. Reimplemented for internal reasons.
     
*/
	public native void setVScrollBarMode( int mode);

/** 
 Sets horizontal scrollbar mode. Reimplemented for internal reasons.
     
*/
	public native void setHScrollBarMode( int mode);

/** 
 Overrides the scrollbar mode.
     
*/
	public native void forceHScrollBarMode( int mode);

/** 
 Overrides the scrollbar mode.
     
*/
	public native void forceVScrollBarMode( int mode);

/** 
 Prints the HTML document.
     
*/
	public native void print();

/** 
 ensure the display is up to date
     
*/
	public native QLayout layout();
	protected native void clear();
	protected native void resizeEvent( QResizeEvent event);
	protected native void showEvent( QShowEvent arg1);
	protected native void hideEvent( QHideEvent arg1);
	protected native boolean focusNextPrevChild( boolean next);
	protected native void drawContents( QPainter p, int clipx, int clipy, int clipw, int cliph);
	protected native void drawContents( QPainter arg1);
	protected native void viewportMousePressEvent( QMouseEvent arg1);
	protected native void focusOutEvent( QFocusEvent arg1);
	protected native void viewportMouseDoubleClickEvent( QMouseEvent arg1);
	protected native void viewportMouseMoveEvent( QMouseEvent arg1);
	protected native void viewportMouseReleaseEvent( QMouseEvent arg1);
	protected native void viewportWheelEvent( QWheelEvent arg1);
	protected native void keyPressEvent( QKeyEvent _ke);
	protected native void keyReleaseEvent( QKeyEvent _ke);
	protected native void contentsContextMenuEvent( QContextMenuEvent _ce);
	protected native void doAutoScroll();
	protected native void timerEvent( QTimerEvent arg1);
	protected native void slotPaletteChanged();
	protected native void slotScrollBarMoved();
}
