package org.kde.koala;
import org.kde.qt.*;


/** Override these methods in subclasses of {@link KFileTreeView} to customise event handling behaviour */
public interface KFileTreeViewEventHandling {

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void focusOutEvent(QFocusEvent fe);
	void childEvent(QChildEvent arg1);
	void viewportDragMoveEvent(QDragMoveEvent arg1);
	void dragMoveEvent(QDragMoveEvent arg1);
	void contentsWheelEvent(QWheelEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void leaveEvent(QEvent e);
	void tabletEvent(QTabletEvent arg1);
	void showEvent(QShowEvent arg1);
	void contentsContextMenuEvent(QContextMenuEvent e);
	void viewportContextMenuEvent(QContextMenuEvent arg1);
	void contextMenuEvent(QContextMenuEvent arg1);
	void viewportMousePressEvent(QMouseEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void imComposeEvent(QIMEvent arg1);
	void customEvent(QCustomEvent arg1);
	void viewportMouseReleaseEvent(QMouseEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void viewportMouseDoubleClickEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void viewportDragLeaveEvent(QDragLeaveEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void contentsDropEvent(QDropEvent ev);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void focusInEvent(QFocusEvent fe);
	void imEndEvent(QIMEvent arg1);
	void contentsDragLeaveEvent(QDragLeaveEvent e);

/** 
 A special keyPressEvent (for FileManager selection mode).
   
*/
	void fileManagerKeyPressEvent(QKeyEvent arg1);
	void viewportDropEvent(QDropEvent arg1);
	void dropEvent(QDropEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMouseDoubleClickEvent(QMouseEvent e);
	void viewportDragEnterEvent(QDragEnterEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void viewportMouseMoveEvent(QMouseEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void contentsDragMoveEvent(QDragMoveEvent e);
	void moveEvent(QMoveEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMouseReleaseEvent(QMouseEvent arg1);
	void viewportWheelEvent(QWheelEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);
	void contentsDragEnterEvent(QDragEnterEvent e);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMouseMoveEvent(QMouseEvent e);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void contentsMousePressEvent(QMouseEvent e);
	void imStartEvent(QIMEvent arg1);
	void closeEvent(QCloseEvent arg1);

/** 
 Reimplemented for internal reasons.
 Further reimplementations should call this function or else
 some features may not work correctly.

 The API is unaffected.
   
*/
	void viewportPaintEvent(QPaintEvent arg1);
	void paintEvent(QPaintEvent arg1);
	void timerEvent(QTimerEvent arg1);

/** 
 Reimplemented for setFullWidth()
   
*/
	void viewportResizeEvent(QResizeEvent e);
	void resizeEvent(QResizeEvent e);
}

