/***************************************************************************
                            KAnimWidget.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a widget used to display animation using multiple
 individual pixmaps.  This widget allows you to deal with variable
 size icons (e.g., ones that will change based on a global setting)
 as it loads the icons internally.  All you need to do is pass along
 a list of icon names and their size and everything else is taken
 care of.

 This widget also emits a 'clicked()' signal when it received a
 mouse press event.

 A quick example:
 <pre>
 StringList icons;
 icons.append("one");
 icons.append("two");
 icons.append("three");
 KAnimWidget anim = new KAnimWidget(icons, 0, this);
 anim.start();
 </pre>

 That example will search for the pixmaps "one.png", "two.png", and
 "three.png" in the share/icons/small/ directories as well as the
 app's pics directory.

 See {@link KAnimWidgetSignals} for signals emitted by KAnimWidget.

 See {@link KAnimWidgetEventHandling} for event handlers to override in subclasses of KAnimWidget.

 @author Kurt Granroth <granroth@kde.org>
 
 @short Widget animated using individual icons.
*/
public class KAnimWidget extends QFrame  {
	protected KAnimWidget(Class dummy){super((Class) null);}

	private native void newKAnimWidget( String icons, int size, QWidget parent, String name);

/** 
 This is the most common constructor.  Pass along the name of the
 animated icons to use (e.g., "kde") for the animation and an
 optional size to load and you're set.  If you omit the size, the
 default size will be used.

*/
	public KAnimWidget( String icons, int size, QWidget parent, String name) {
		super((Class) null);
		newKAnimWidget( icons, size, parent, name);
	}
	private native void newKAnimWidget( String icons);
	public KAnimWidget( String icons) {
		super((Class) null);
		newKAnimWidget( icons);
	}
	private native void newKAnimWidget( QWidget parent, String name);

/** 
 Default constructor.  This will not do anything until you use
 {@link #setIcons} later.

*/
	public KAnimWidget( QWidget parent, String name) {
		super((Class) null);
		newKAnimWidget( parent, name);
	}
	private native void newKAnimWidget();
	public KAnimWidget() {
		super((Class) null);
		newKAnimWidget();
	}

/** 
 Destructor
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Starts the animation from frame 1
   
*/
	public native void start();

/** 
 Stops the animation.  This will also reset the widget to frame 1.
   
*/
	public native void stop();

/** 
 Sets the size of the icons.

*/
	public native void setSize( int size);

/** 
 Sets the name of the animated icons to load.  This will use the
 KIconLoader.loadAnimated method for the actual loading.

*/
	public native void setIcons( String icons);
	protected native void drawContents( QPainter p);
	protected native void slotTimerUpdate();
	protected native void updateIcons();
}
