/***************************************************************************
                            kde_KStatusBar.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSTATUSBAR
#define KDE_KSTATUSBAR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

  Display status messages.

  You can insert text labels or custom widgets. Their geometry is managed
  internally. KStatusBar resizes itself, but positioning is left to
  @ref KMainWindow (or to you, if you don't use @ref KMainWindow ).

  A special type of item is a message which is a temporary text-message
  displayed on top of other items in full-width. Messages are visible for
  specified time, or until you call the slot @ref QStatusBar::clear(). See
  @ref QStatusBar::message for details.

  KStatusBar inherits @ref QStatusBar, you can freely use all @ref QStatusBar
  methods.

  Empty text items are not visible. They will become visible when you change
  (add) text.

 @author Mark Donohoe (donohoe@kde.org) Maintained by Sven Radej <radej@kde.org>

 @version $Id: kde_KStatusBar.h,v 1.3 2002/02/21 00:43:13 rdale Exp $
 
 @short KDE statusbar widget.
*/
#define KSTATUSBAR_Toggle	0
#define KSTATUSBAR_Show	1
#define KSTATUSBAR_Hide	2

/** 
  Constructs a status bar. @p parent is usually @ref KMainWindow.
   
*/
kde_KStatusBar * kde_new_KStatusBar(qt_QWidget * parent, char* name);

/** 
  Destructor.

  Deletes all internal objects.
   
*/
void kde_del_KStatusBar( kde_KStatusBar* p );

/** 
  Inserts a text label into the status bar.
  Paremeters @p stretch and  @p permanent are passed to
  @ref QStatusBar::addWidget .

  If @p permanent is true, then item will be placed on the far right of
  the statusbar and will never be hidden by @ref QStatusBar::message.

   
*/
void kde_KStatusBar_insertItem(kde_KStatusBar* instPointer,qt_QString * text, int identifier, int stretch, int permanent);

/** 
  Inserts a fixed width text label into status bar. The width will be set
  according to @p text, but will remain fixed even if you change text.
  You can change fixed width by calling @ref setItemFixed.

*/
void kde_KStatusBar_insertFixedItem(kde_KStatusBar* instPointer,qt_QString * text, int identifier, int permanent);

/** 
  Removes an item.

*/
void kde_KStatusBar_removeItem(kde_KStatusBar* instPointer,int identifier);

/** 
 Changes the text in a status bar field.

 The item will be resized to fit the text. If you change text to be empty,
 item will not be visible (untill you add some text).

*/
void kde_KStatusBar_changeItem(kde_KStatusBar* instPointer,qt_QString * text, int identifier);

/** 
 Sets the alignment of item @p id. By default all fields are aligned
 @p AlignHCenter | @p AlignVCenter. See @ref QLabel::setAlignment for details.

  
*/
void kde_KStatusBar_setItemAlignment(kde_KStatusBar* instPointer,int identifier, int align);

/** 
 Sets item @p id to have fixed width. This cannot be undone, but you can
 always set new fixed width.

*/
void kde_KStatusBar_setItemFixed(kde_KStatusBar* instPointer,int identifier, int width);

#endif
