/***************************************************************************
                            kde_KDualColorButton.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDUALCOLORBUTTON
#define KDE_KDUALCOLORBUTTON

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 KDualColorButton allows the user to select two cascaded colors (usually a
 foreground and background color). Other features include drag and drop
 from other KDE color widgets, a reset to black and white control, and a
 swap colors control.

 When the user clicks on the foreground or background rectangle the
 rectangle is first sunken and the @ref currentChanged() signal is emitted.
 Further clicks will present a color dialog and emit either the @ref fgChanged()
 or @ref bgChanged() if a new color is selected.

 Note: With drag and drop when dropping a color the current selected color
 will be set, while when dragging a color it will use whatever color
 rectangle the mouse was pressed inside.

 @author Daniel M. Duley <mosfet@kde.org>
 
 @short A widget for selecting two related colors.

*/
#define KDUALCOLORBUTTON_Foreground	0
#define KDUALCOLORBUTTON_Background	1

/** 
 Constructs a new KDualColorButton using the default black and white
 colors.

     
*/
kde_KDualColorButton * kde_new_KDualColorButton(qt_QWidget * parent, char* name, qt_QWidget * dialogParent);

/** 
 Constructs a new KDualColorButton with the supplied foreground and
 background colors.
     
*/
kde_KDualColorButton * kde_new_KDualColorButton1(qt_QColor * fgColor, qt_QColor * bgColor, qt_QWidget * parent, char* name, qt_QWidget * dialogParent);
void kde_del_KDualColorButton( kde_KDualColorButton* p );

/** 
 Returns the current foreground color.
     
*/
qt_QColor * kde_KDualColorButton_foreground(kde_KDualColorButton* instPointer);

/** 
 Returns the current background color.
     
*/
qt_QColor * kde_KDualColorButton_background(kde_KDualColorButton* instPointer);

/** 
 Returns the current color item selected by the user.
     
*/
int kde_KDualColorButton_current(kde_KDualColorButton* instPointer);

/** 
 Returns the color of the selected item.
     
*/
qt_QColor * kde_KDualColorButton_currentColor(kde_KDualColorButton* instPointer);

/** 
 Returns the minimum size needed to display the widget and all its
 controls.
     
*/
qt_QSize * kde_KDualColorButton_sizeHint(kde_KDualColorButton* instPointer);

/** 
 Sets the foreground color.
     
*/
void kde_KDualColorButton_setForeground(kde_KDualColorButton* instPointer,qt_QColor * c);

/** 
 Sets the background color.
     
*/
void kde_KDualColorButton_setBackground(kde_KDualColorButton* instPointer,qt_QColor * c);

/** 
 Sets the current selected color item.
     
*/
void kde_KDualColorButton_setCurrent(kde_KDualColorButton* instPointer,int s);

/** 
 Sets the color of the selected item.
     
*/
void kde_KDualColorButton_setCurrentColor(kde_KDualColorButton* instPointer,qt_QColor * c);

/** 
 Sets the supplied rectangles to the proper size and position for the
 current widget size. You can reimplement this to change the layout
 of the widget. Restrictions are that the swap control will always
 be at the top right, the reset control will always be at the bottom
 left, and you must leave at least a 14x14 space in those corners.
     
*/
void kde_KDualColorButton_metrics(kde_KDualColorButton* instPointer,qt_QRect* fgRect, qt_QRect* bgRect);

#endif
