/***************************************************************************
                            kde_KCommandHistory.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCOMMANDHISTORY
#define KDE_KCOMMANDHISTORY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The command history stores a (user) configurable amount of
 Commands. It keeps track of its size and deletes commands
 if it gets too large. The user can set a maximum undo and
 a maximum redo limit (e.g. max. 50 undo / 30 redo commands).
 The KCommandHistory keeps track of the "borders" and deletes
 commands, if appropriate. It also activates/deactivates the
 undo/redo actions in the menu and changes the text according
 to the name of the command.
 
 @short 
 The command history stores a (user) configurable amount of
 Commands.
*/

/** 
 Creates a command history, to store commands.
 This constructor doesn't create actions, so you need to call
 @ref undo and @ref redo yourself.
     
*/
kde_KCommandHistory * kde_new_KCommandHistory();

/** 
 Creates a command history, to store commands.
 This also creates an undo and a redo action, in the @p actionCollection,
 using the standard names ("edit_undo" and "edit_redo").

*/
kde_KCommandHistory * kde_new_KCommandHistory1(kde_KActionCollection* actionCollection, int withMenus);

/** 
 Destructs the command history object.
     
*/
void kde_del_KCommandHistory( kde_KCommandHistory* p );

/** 
 Erases all the undo/redo history.
 Use this when reloading the data, for instance, since this invalidates
 all the commands.
     
*/
void kde_KCommandHistory_clear(kde_KCommandHistory* instPointer);

/** 
 Adds a command to the history. Call this for each @p command you create.
 Unless you set @p execute to false, this will also execute the command.
 This means, most of the application's code will look like
    MyCommand * cmd = new MyCommand(i18n("The name"), parameters);
    m_historyCommand.addCommand( cmd );
     
*/
void kde_KCommandHistory_addCommand(kde_KCommandHistory* instPointer,kde_KCommand* command, int execute);

/** 

*/
int kde_KCommandHistory_undoLimit(kde_KCommandHistory* instPointer);

/** 
 Sets the maximum number of items in the undo history.
     
*/
void kde_KCommandHistory_setUndoLimit(kde_KCommandHistory* instPointer,int limit);

/** 

*/
int kde_KCommandHistory_redoLimit(kde_KCommandHistory* instPointer);

/** 
 Sets the maximum number of items in the redo history.
     
*/
void kde_KCommandHistory_setRedoLimit(kde_KCommandHistory* instPointer,int limit);

/** 
 Enable or disable the undo and redo actions.
 This isn't usually necessary, but this method can be useful if
 you disable all actions (to go to a "readonly" state), and then
 want to come back to a readwrite mode.
     
*/
void kde_KCommandHistory_updateActions(kde_KCommandHistory* instPointer);

/** 
 Undoes the last action.
 Call this if you don't use the builtin KActions.
     
*/
void kde_KCommandHistory_undo(kde_KCommandHistory* instPointer);

/** 
 Redoes the last undone action.
 Call this if you don't use the builtin KActions.
     
*/
void kde_KCommandHistory_redo(kde_KCommandHistory* instPointer);

/** 
 Remembers when you saved the document.
 Call this right after saving the document. As soon as
 the history reaches the current index again (via some
 undo/redo operations) it will emit @ref documentRestored
 If you implemented undo/redo properly the document is
 the same you saved before.
     
*/
void kde_KCommandHistory_documentSaved(kde_KCommandHistory* instPointer);
void kde_KCommandHistory_slotUndoAboutToShow(kde_KCommandHistory* instPointer);
void kde_KCommandHistory_slotUndoActivated(kde_KCommandHistory* instPointer,int arg1);
void kde_KCommandHistory_slotRedoAboutToShow(kde_KCommandHistory* instPointer);
void kde_KCommandHistory_slotRedoActivated(kde_KCommandHistory* instPointer,int arg1);

#endif
