/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs_noglade.c,v 1.4 2000/04/19 01:29:29 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "main.h"
#include "misc.h"
#ifdef USE_GNOME
#include <gnome.h>
#endif
#include "toolbar.h"
#include "prefs.h"
#include "prefs_private.h"
#include "prefs_noglade.h"

#include "gnpintl.h"

#ifndef USE_LIBGLADE

/*** local function prototypes ***/
static void		prefs_frame_doctab_create(GtkWidget *parent_vbox);
static void		prefs_frame_msgbar_create(GtkWidget *parent);
static GtkWidget *	prefs_check_button_with_label_create(
				GtkWidget *, char *, long , char *,
				GtkWidget *table,
				int lft1, int rht1, int top1, int bot1);
static GtkWidget *	prefs_spin_button_with_label_create(
				GtkWidget *, char *, float , float , float ,
				float , float , float , char *,
				GtkWidget *table,
				int lft1, int rht1, int top1, int bot1,
				int lft2, int rht2, int top2, int bot2);
static GtkWidget *	prefs_pulldown_with_label_create(
				GtkWidget *, char *, GList *, char *, int);
static void		prefs_box_in_frame(char *frametext, int border_width,
				GtkWidget **frame, GtkWidget **vbox, bool_t);
#ifdef WANT_MSGBOX
static void		prefs_frame_msgbox_create(GtkWidget *parent);
#else
# define		prefs_frame_msgbox_create(parent)
#endif  /* #ifdef WANT_MSGBOX */

#ifdef USE_TOOLBARS
static void		prefs_frame_toolbar_create(GtkWidget *parent_vbox);
static GtkWidget *	prefs_radio_button_with_label_create(
				GtkWidget *, GtkWidget *, char *, long, char *);
static GtkWidget *	prefs_frame_tb(GtkWidget *nb, char *pagename,
				       int , toolbar_data_t *tbdtable);
#else
# define		prefs_frame_toolbar_create(parent)
#endif

#ifdef USE_SOURCE_CTRL
static void		prefs_frame_scc_selection(GtkWidget *parent);
#endif


#ifdef USE_SOURCE_CTRL
/*
 * PRIVATE: prefs_frame_scc_selection
 *
 * creates the pulldown combo box for selecting the method of source code
 * control.
 */
static void
prefs_frame_scc_selection(GtkWidget *parent)
{
	GtkWidget *frame, *vbox;
	int i;
	GList *scc_list;

	/* list is freed in prefs_wgtopt_list_free() */
	scc_list = NULL;
	for (i = 0; i < SCC_NUM_TYPES; i++)
		scc_list = g_list_append(scc_list,
					 gettext(scc_tbl[i].scc_desc_name));

	prefs_box_in_frame(_("Source Control Configuration"), 0, &frame, &vbox,
			   TRUE);

	(void)prefs_pulldown_with_label_create(
			vbox,
			_(" Source Control Program "),
			scc_list,
			"scc_selected",
			prefs.scc_selected
			);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, TRUE, TRUE, 0);
} /* prefs_frame_doctab_create */


/*
 * PRIVATE: prefs_page_scc_create
 *
 * creates the notebook page for configuration of source code control options.
 */
void
prefs_page_scc_create(GtkWidget *prefs_nb)
{
	GtkWidget *scc_nb, *vbox, *tmp;
	GtkWidget *frame, *table;
	int i, j;

	/* create notebook to hold all the source code control systems */
	scc_nb = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(scc_nb), GTK_POS_TOP);
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(scc_nb), TRUE);
	gtk_notebook_popup_enable(GTK_NOTEBOOK(scc_nb));

	for (i = 0; i < SCC_NUM_TYPES; i++) {
		prefs_box_in_frame(gettext(scc_tbl[i].scc_desc_name),
                           10, &frame, &vbox, TRUE);
		table = gtk_table_new(SCC_NUM_CMDS, 2, FALSE);
		gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
		gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

		for (j = 0; j < SCC_NUM_CMDS; j++) {
			tmp = misc_entry_w_label_create(
					vbox,
					gettext(scc_cmd_desc[j]),
					prefs.scc[i][j],
					table, 0, 1, j, j + 1, 1, 2, j, j + 1);
			prefs_wgtopt_list_add(tmp, EntryType, NULL,
					      scc_tbl[i].scc_cmds[j].pref);
		}

		tmp = gtk_label_new(gettext(scc_tbl[i].scc_desc_name));
		gtk_notebook_append_page(GTK_NOTEBOOK(scc_nb), frame, tmp);
	}

	/* XXX - this doesn't appear to work?! */
	gtk_notebook_set_page(GTK_NOTEBOOK(scc_nb), (int)prefs.scc_selected);

	vbox = gtk_vbox_new(FALSE, 0);
	prefs_frame_scc_selection(vbox);
	gtk_box_pack_start(GTK_BOX(vbox), scc_nb, FALSE, FALSE, 0);

	tmp = gtk_label_new(_("Source Control"));
	gtk_notebook_append_page(GTK_NOTEBOOK(prefs_nb), vbox, tmp);
} /* prefs_page_scc_create */
#endif	/* USE_SOURCE_CTRL */


/*
 * PRIVATE: prefs_page_window_create
 *
 * creates the page titled "Window"
 *
 * 3. Window
 *	save window height on exit	(check button)
 *	default window height		(spin button)
 *	save window width on exit	(check button)
 *	default window width		(spin button)
 *
 *	save window position on exit	(check button)
 *	default window x-position	(spin button)
 *	default window y-position	(spin button)
 */
void
prefs_page_window_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *table;

	prefs_box_in_frame(_("Window Settings"), 10, &frame, &vbox, TRUE);

	table = gtk_table_new(13, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

	/* save window height on exit */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Save Window height on exit "),
			IS_SAVE_WIN_HEIGHT(),
			"save_win_height",
			table, 0, 2, 0, 1);

	/* save window width on exit */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Save Window width on exit "),
			IS_SAVE_WIN_WIDTH(),
			"save_win_width",
			table, 0, 2, 2, 3);

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 4, 5);

	/* save window position on exit */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Save Window Position on Exit "),
			IS_SAVE_WIN_POS(),
			"save_win_pos",
			table, 0, 2, 5, 6);

	/* default window xpos */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Default x-pos (-1 for auto) "),
			(float)prefs.win_xpos, -1.0, 2048.0, 1.0, 1.0, 0,
			"win_xpos",
			table, 0, 1, 6, 7, 1, 2, 6, 7);

	/* default window ypos */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Default y-pos (-1 for auto) "),
			(float)prefs.win_ypos, -1.0, 2048.0, 1.0, 1.0, 0,
			"win_ypos",
			table, 0, 1, 7, 8, 1, 2, 7, 8);

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 8, 9);

	/* put username in window's titlebar */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Show username in window title "),
			IS_USER_NAME_IN_TITLE(),
			"win_user_in_title",
			table, 0, 2, 9, 10);

	/* put hostname in window's titlebar */
	(void)prefs_check_button_with_label_create(
			vbox,
			_(" Show hostname in window title "),
			IS_HOST_NAME_IN_TITLE(),
			"win_host_in_title",
			table, 0, 2, 10, 11);

#ifdef USE_RANDOMTIPS
	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 10, 11);

	/* random tips spin button */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Random tips secs (0 disables) "),
			(float)prefs.random_tips, 0.0, 86400.0, 1.0, 1.0, 0.0,
			"random_tips_delay",
			table, 0, 1, 12, 13, 1, 2, 12, 13);
#endif	/* USE_RANDOMTIPS */

	/* stuff into notebook */
	tmp = gtk_label_new(_("Window"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_window_create */


/*
 * PRIVATE: prefs_page_document_create
 *
 * creates the notebook page titled "Document"
 *
 * 2. Document
 *	autosave		(spin button)
 *	max num of recent docs	(spin button)
 *	wordwrap on/off		(check button)
 *	fonts			(popup must return string)
 *	colors			(popup must return string)
 */
void
prefs_page_document_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *table;

	prefs_box_in_frame(_("Document Settings"), 10, &frame, &vbox, TRUE);

	table = gtk_table_new(11, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

	/* tab stop */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Tab stop width "),
			(float)prefs.tab_stop, 1.0, 256.0, 1.0, 1.0, 0.0,
			"tab_stop",
			table, 0, 1, 0, 1, 1, 2, 0, 1);
#ifdef USE_AUTOSAVE
	/* autosave spin button */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Autosave minutes (0 disables) "),
			(float)prefs.autosave, 0.0, 1440.0, 1.0, 1.0, 0.0,
			"autosave_timeout",
			table, 0, 1, 1, 2, 1, 2, 1, 2);
#endif	/* USE_AUTOSAVE */
#ifdef USE_RECENT
	/* max num of recent doc */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Maximum # of recent documents "),
			(float)prefs.maxrecent, 0.0, 255.0, 1.0, 1.0, 0.0,
			"max_num_recent",
			table, 0, 1, 2, 3, 1, 2, 2, 3);
#endif	/* USE_RECENT */
#if defined(USE_UNDOREDO) && defined(GTK_HAVE_FEATURES_1_1_0)
	/* max levels of undo/redo */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Maximum # of undos (-1 for no limit) "),
			(float)prefs.maxundo, -1.0, 32768.0, 1.0, 1.0, 0.0,
			"max_undo",
			table, 0, 1, 3, 4, 1, 2, 3, 4);
#endif
	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 4, 5);

	/* word wrap */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Use wordwrap"),
			IS_USE_WORDWRAP(),
			"use_wordwrap",
			table, 0, 2, 5, 6);

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 6, 7);

#ifdef USE_BACKUP
	/* write backup */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Write backup file"),
			IS_DO_BACKUP(),
			"do_backup",
			table, 0, 1, 7, 8);

	tmp = misc_entry_w_label_create(
			vbox, _(" Backup directory "), prefs.backupdir,
			table, 0, 1, 8, 9, 1, 2, 8, 9);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "backupdir");

	tmp = misc_entry_w_label_create(
			vbox, _(" Backup file suffix "), prefs.backupsuffix,
			table, 0, 1, 9, 10, 1, 2, 9, 10);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "backupsuffix");
#endif	/* USE_BACKUP */

	tmp = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), tmp, 0, 2, 10, 11);

	/* stuff into notebook */
	tmp = gtk_label_new(_("Document"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_document_create */


#ifdef USE_TOOLBARS
/*
 * PRIVATE: prefs_page_main_tb
 *
 * creates the notebook page for the "Main Toolbar Buttons"
 */
extern toolbar_data_t main_tbdata[];

void
prefs_page_main_tb(GtkWidget *nb)
{
	GtkWidget *frame;

	frame = prefs_frame_tb(nb, _("Main Toolbar"), 6, main_tbdata);

	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame,
				 gtk_label_new(_("Main Toolbar")));
} /* prefs_page_main_tb */


# ifdef USE_HTMLTAGS
/*
 * PRIVATE: prefs_page_html_tb
 *
 * creates the notebook page for the "HTML Toolbar Buttons"
 */
extern toolbar_data_t html_tbdata[];

void
prefs_page_html_tb(GtkWidget *nb)
{
	GtkWidget *f1, *f2, *vbox;

	prefs_box_in_frame(_("HTML Toolbar Settings"), 7, &f1, &vbox, TRUE);
	(void)prefs_check_button_with_label_create(
			   vbox, _("Use Advanced HTML Toolbars"),
			   (long)prefs_bool_by_name("advanced_html_tb"),
			   "advanced_html_tb", NULL, -1, -1, -1, -1);

	f2 = prefs_frame_tb(nb, _("Main HTML Toolbar Buttons"), 10, html_tbdata);
	gtk_box_pack_start(GTK_BOX(vbox), f2, FALSE, FALSE, 0);

	gtk_notebook_append_page(GTK_NOTEBOOK(nb), f1,
				 gtk_label_new(_("HTML Toolbar")));
} /* prefs_page_html_tb */
# endif	/* USE_HTMLTAGS */


/*
 * PRIVATE: prefs_frame_tb
 *
 * returns a frame filled with buttons for the toolbar configuration.
 */
static GtkWidget *
prefs_frame_tb(GtkWidget *nb, char *pagename, int num_per_column,
	       toolbar_data_t *tbdtable)
{
	GtkWidget *frame, *hbox, *tbvbox, *vb = NULL;
	toolbar_data_t *tbdp;
	int count;

	prefs_box_in_frame(pagename, 7, &frame, &tbvbox, TRUE);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tbvbox), hbox, FALSE, FALSE, 0);

	for (count = 0, tbdp = tbdtable; tbdp->text; tbdp++) {
		if (count % num_per_column == 0) {
			vb = gtk_vbox_new(FALSE, 0);
			gtk_box_pack_start(GTK_BOX(hbox), vb, FALSE, FALSE, 0);
		}

		if (strcmp(tbdp->text, " SPACE ") == 0)
			continue;

		(void)prefs_check_button_with_label_create(
				vb,
				gettext(tbdp->tooltip_text),
				(long)prefs_bool_by_name(tbdp->prefname),
				tbdp->prefname,
				NULL, -1, -1, -1, -1);

		count++;
	}

	return frame;
} /* prefs_frame_tb */
#endif	/* USE_TOOLBARS */


/*
 * PRIVATE: prefs_page_fonts_colors
 *
 * creates the notebook page titled "Fonts and Colors"
 *
 * Fonts and Colors
 *	Font Selection		(push button w/label)
 *	Text Foreground		(push button w/label)
 *	Text Background		(push button w/label)
 *	Highlight Foreground	(push button w/label)
 *	Highlight Background	(push button w/label)
 */
struct prefs_page_fonts_colors_nfo {
	char *labeltext;
	GtkSignalFunc cbfunc;
	char *preftext;
	gpointer pdata;
	which_text_t which;
};
typedef struct prefs_page_fonts_colors_nfo prefs_pfcn_t;


#ifdef USE_GNOME
static GtkWidget *
prefs_gnome_color_picker(prefs_pfcn_t *pb, GtkWidget *parent)
{
	GtkWidget *tmp, *l, *h;
	GdkColor *gcp = (GdkColor *)pb->pdata;

	h = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), h, FALSE, FALSE, 0);
	l =  gtk_label_new(gettext(pb->labeltext));
	gtk_box_pack_start(GTK_BOX(h), l, FALSE, FALSE, 0);

	tmp = gnome_color_picker_new();

	gtk_signal_connect(GTK_OBJECT(tmp), "color_set",
			   GTK_SIGNAL_FUNC(pb->cbfunc),
			   GINT_TO_POINTER(pb->which));

	gnome_color_picker_set_dither(GNOME_COLOR_PICKER(tmp), FALSE);
	gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(tmp), FALSE);
	gtk_box_pack_end(GTK_BOX(h), tmp, FALSE, FALSE, 0);

	gnome_color_picker_set_i16(GNOME_COLOR_PICKER(tmp),
				   gcp->red, gcp->green, gcp->blue, 0);

	return tmp;
} /* prefs_gnome_color_picker */


static GtkWidget *
prefs_gnome_font_picker(prefs_pfcn_t *pb, GtkWidget *parent)
{
	GtkWidget *tmp = gnome_font_picker_new();
	gtk_signal_connect(GTK_OBJECT(tmp), "font_set",
			   GTK_SIGNAL_FUNC(pb->cbfunc), NULL);
	gnome_font_picker_set_title(GNOME_FONT_PICKER(tmp),
				    _("Font Selection..."));
	gnome_font_picker_set_mode(GNOME_FONT_PICKER(tmp),
				   GNOME_FONT_PICKER_MODE_FONT_INFO);
	gnome_font_picker_set_font_name(GNOME_FONT_PICKER(tmp),
					*(char **)pb->pdata);
	/*
	 * look at the name of this next gnome function.  why the hell is it so
	 * long?  someone has a serious function-naming-growth-hormone-problem.
	 */
	gnome_font_picker_fi_set_use_font_in_label(GNOME_FONT_PICKER(tmp),
						   TRUE, 14);
	/* don't show the size; something is screwed up with
	 * the gnome font picker */
	gnome_font_picker_fi_set_show_size(GNOME_FONT_PICKER(tmp), FALSE);
	gtk_box_pack_start(GTK_BOX(parent), tmp, FALSE, FALSE, 10);

	return tmp;
} /* prefs_gnome_font_picker */
#endif	/* USE_GNOME */


void
prefs_page_fonts_colors(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *vbox2, *tmp, *hbox;
#ifdef GTK_HAVE_FEATURES_1_1_0
	GSList *senslist = NULL;
	GtkWidget *sensitive;
#endif
	prefs_pfcn_t *pb;
	prefs_pfcn_t pfcn_buttons[] = {
		{
			N_("Font Selection"),
			GTK_SIGNAL_FUNC(prefs_font_sel_cb),
			"text_font",
			&prefs.text_font_str
		},
		{
			N_("Text Foreground"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_fg_color",
			&prefs.text_fg_color,
			Foreground
		},
		{
			N_("Text Background"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_bg_color",
			&prefs.text_bg_color,
			Background
		},
		{
			N_("Highlighted Foreground"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_hlfg_color",
			&prefs.text_hlfg_color,
			HighlightFg
		},
		{
			N_("Highlighted Background"),
			GTK_SIGNAL_FUNC(prefs_text_color_cb),
			"text_hlbg_color",
			&prefs.text_hlbg_color,
			HighlightBg
		},
		{ NULL }
	};

	prefs_box_in_frame(_("Fonts and Colors"), 10, &frame, &vbox, TRUE);
	/* stuff into notebook */
	tmp = gtk_label_new(_("Fonts/Colors"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);

	/* fonts and colors */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
#ifdef GTK_HAVE_FEATURES_1_1_0
	senslist = g_slist_prepend(senslist, hbox);
#endif

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, TRUE, TRUE, 10);

	for (pb = pfcn_buttons; pb->labeltext; pb++) {
#ifdef USE_GNOME
		if (strcmp(pb->labeltext, "Font Selection") == 0)
			tmp = prefs_gnome_font_picker(pb, vbox2);
		else
			tmp = prefs_gnome_color_picker(pb, vbox2);
#else
		tmp = misc_button_new_w_label(
			pb->labeltext, NULL,
			GTK_SIGNAL_FUNC(pb->cbfunc),
			GINT_TO_POINTER(pb->which),
			vbox2,
			PACK_START | PACK_EXPAND | PACK_FILL | NO_RELIEF,
			0);
#endif
		prefs_wgtopt_list_add(tmp, GenericType, NULL, pb->preftext);
	}

#ifdef GTK_HAVE_FEATURES_1_1_0
	frame = gtk_frame_new(_("Sample Output"));
	gtk_container_border_width(GTK_CONTAINER(frame), 10);

	prefs_txt = gtk_text_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(frame), prefs_txt);
	gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 10);
#else
	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 10);
	tmp = gtk_label_new(
		_(" NOTE: for gtk-1.0.x, font and color changes \n"
		" take effect the next time you run gnotepad+ "));
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 10);
#endif

	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 0);

#ifdef GTK_HAVE_FEATURES_1_1_0
	/* use gtk theme settings button */
	sensitive = prefs_check_button_with_label_create(
				vbox,
				"Use GTK theme settings, not gnotepad's",
				IS_USE_GTK_THEME_FONTS(),
				"use_theme_settings",
				NULL, 0, 0, 0, 0);
	(void)gtk_signal_connect(GTK_OBJECT(sensitive), "clicked",
				 GTK_SIGNAL_FUNC(fonts_colors_sens_cb),
				 senslist);
	prefs_wgtopt_list_add(sensitive, ButtonType, senslist,
			      "use_theme_settings");
	fonts_colors_sens_cb(sensitive, senslist);
#endif

	(void)prefs_check_button_with_label_create(
			vbox,
			_("Use fontset"),
			IS_USE_FONTSET(),
			"use_fontset",
			NULL, 0, 1, 5, 6);
} /* prefs_page_fonts_colors */


/*
 * PRIVATE: prefs_frame_msgbar_create
 *
 * creates the frame to contain options for the message bar
 */
static void
prefs_frame_msgbar_create(GtkWidget *parent)
{
	GtkWidget *frame, *tmp, *vbox;

	prefs_box_in_frame(_("Message Bar"), 0, &frame, &vbox, TRUE);

	/* 'show msg bar' check box */
	tmp = prefs_check_button_with_label_create(
			vbox,
			_("Show msg bar"),
			IS_SHOW_MSGBAR(),
			"show_message_bar",
			NULL, -1, -1, -1, -1);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, TRUE, TRUE, 0);
} /* prefs_frame_msgbar_create */


/*
 * PRIVATE: prefs_frame_doctab_create
 *
 * creates the frame to contain options for the document tabs
 */
static void
prefs_frame_doctab_create(GtkWidget *parent)
{
	GtkWidget *frame, *vbox;
	GList *tabpos_list;

	/* list is freed in prefs_wgtopt_list_free() */
	tabpos_list = NULL;
	tabpos_list = g_list_prepend(tabpos_list, _("Bottom"));
	tabpos_list = g_list_prepend(tabpos_list, _("Top"));
	tabpos_list = g_list_prepend(tabpos_list, _("Right"));
	tabpos_list = g_list_prepend(tabpos_list, _("Left"));

	prefs_box_in_frame(_("Document Tabs"), 0, &frame, &vbox, TRUE);

	/* 'show doc tabs' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show doc tabs"),
			IS_SHOW_TABS(),
			"show_doc_tabs",
			NULL, -1, -1, -1, -1);

	/* tab position */
	(void)prefs_pulldown_with_label_create(
			vbox,
			_(" Tab position "),
			tabpos_list,
			"doc_tab_position",
			prefs.tabpos
			);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, TRUE, TRUE, 0);
} /* prefs_frame_doctab_create */


/*
 * PRIVATE: prefs_page_appearance_create
 *
 * creates the notebook page titled "Appearance"
 *
 * 1. Appearance
 *	toolbar on/off		(check button)
 *	toolbar style		(radio buttons)
 *	tooltips on/off		(check button)
 *	doc tabs on/off		(check button)
 *	doc tabs position	(pulldown combo entry text)
 *	msgbar on/off		(check button)
 */
void
prefs_page_appearance_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *hbox;

	prefs_box_in_frame(_("Appearance Settings"), 10, &frame, &vbox, TRUE);

	prefs_frame_toolbar_create(vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(vbox), hbox);

	prefs_frame_doctab_create(hbox);
	prefs_frame_msgbar_create(hbox);

	/* stuff into notebook */
	tmp = gtk_label_new(_("Appearance"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_appearance_create */


#ifdef USE_TOOLBARS
/*
 * PRIVATE: prefs_frame_toolbar_create
 *
 * creates the frame to contain options for the toolbar
 */
static void
prefs_frame_toolbar_create(GtkWidget *parent)
{
	GtkWidget *frame, *hbox, *vbox, *radio, *tbvbox;

	prefs_box_in_frame(_("Toolbar Settings"), 0, &frame, &tbvbox, TRUE);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tbvbox), hbox, FALSE, FALSE, 0);

	/* put first two checkboxes into one vbox */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);

	/* 'show toolbar' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show Toolbar"),
			IS_SHOW_TOOLBAR(),
			"show_toolbar",
			NULL, -1, -1, -1, -1);

	/* 'show tooltips' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show Tooltips"),
			IS_SHOW_TOOLTIPS(),
			"show_tooltips",
			NULL, -1, -1, -1, -1);

#ifdef GTK_HAVE_FEATURES_1_1_0
	/* 'raised buttons' check box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Raised Buttons"),
			IS_TOOLBAR_RAISED(),
			"toolbar_raised",
			NULL, -1, -1, -1, -1);

#endif

	/* now another vbox into the hbox */
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);

	/* radio buttons for toolbar style */
	radio = prefs_radio_button_with_label_create(
			vbox,
			NULL,
			_("Pictures and Text"),
			IS_TEXT_PIC_TOOLBAR(),
			"toolbar_pictext");
	(void)prefs_radio_button_with_label_create(
			vbox,
			radio,
			_("Pictures Only"),
			IS_PIC_TOOLBAR(),
			"toolbar_piconly");
	(void)prefs_radio_button_with_label_create(
			vbox,
			radio,
			_("Text Only"),
			IS_TEXT_TOOLBAR(),
			"toolbar_textonly");
	gtk_box_pack_start(GTK_BOX(tbvbox), gtk_hseparator_new(),
			   FALSE, FALSE, 0);

#ifdef USE_HTMLTAGS
	/* 'show html toolbar' check box */
	(void)prefs_check_button_with_label_create(
			tbvbox,
			_("Show Html Toolbar"),
			IS_SHOW_HTML_TOOLBAR(),
			"show_html_toolbar",
			NULL, -1, -1, -1, -1);
#endif	/* USE_HTMLTAGS */

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, FALSE, FALSE, 0);
} /* prefs_frame_toolbar_create */
#endif	/* USE_TOOLBARS */


/*
 * PRIVATE: prefs_page_misc_create
 *
 * creates the notebook page titled "Miscellaneous"
 *
 * 4. Misc
 *	tmpdir				(text entry string)
 *	printcmd			(text entry string)
 *	msgbox on/off			(check button)
 *	max # msgs			(spin button w/ text entry)
 *	msgbox truncate percentage	(spin button w/ text entry)
 */
void
prefs_page_misc_create(GtkWidget *nb)
{
	GtkWidget *frame, *vbox, *tmp, *table;

	prefs_box_in_frame(_("Miscellaneous"), 10, &frame, &vbox, TRUE);

	table = gtk_table_new(4, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

#ifdef WANT_SESSION
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Save session on exit"),
			IS_ENABLE_SESSION(),
			"enable_session",
			NULL, -1, -1, -1, -1);
#endif
#ifdef WANT_SPLASH
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Show splash/init screen"),
			IS_SHOW_SPLASH(),
			"show_splash",
			NULL, -1, -1, -1, -1);
#endif

	/* print cmd */
	tmp = misc_entry_w_label_create(
			vbox, _(" Custom print command "), prefs.printcmd,
			table, 0, 1, 0, 1, 1, 2, 0, 1);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "print_command");

	/* tmp dir */
	tmp = misc_entry_w_label_create(
			vbox, _(" Temp directory "), prefs.tmpdir,
			table, 0, 1, 1, 2, 1, 2, 1, 2);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "tmp_directory");
#ifdef USE_SHELL_INSERT
	/* shell */
	tmp = misc_entry_w_label_create(
			vbox, _(" Shell "), prefs.shell,
			table, 0, 1, 2, 3, 1, 2, 2, 3);
	prefs_wgtopt_list_add(tmp, EntryType, NULL, "shell");
#endif	/* USE_SHELL_INSERT */

	/* read buf size */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Read buffer size (bytes) "),
			(float)prefs.read_size, 1.0, 65536.0, 1.0, 1.0, 0,
			"read_buf_size",
			table, 0, 1, 3, 4, 1, 2, 3, 4);

	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), tmp, FALSE, FALSE, 0);

	prefs_frame_msgbox_create(vbox);

	/* stuff into notebook */
	tmp = gtk_label_new(_("Misc"));
	gtk_notebook_append_page(GTK_NOTEBOOK(nb), frame, tmp);
} /* prefs_page_misc_create */


#ifdef WANT_MSGBOX
/*
 * PRIVATE: prefs_frame_msgbox_create
 *
 * creates the frame containing the options for the msgbox
 *
 *	msgbox on/off			(check button)
 *	max # msgs			(spin button w/ text entry)
 *	msgbox truncate percentage	(spin button w/ text entry)
 */
static void
prefs_frame_msgbox_create(GtkWidget *parent)
{
	GtkWidget *frame, *vbox, *table;

	prefs_box_in_frame(_("Message Box"), 0, &frame, &vbox, TRUE);

	table = gtk_table_new(1, 2, FALSE);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 10);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);

	/* use msg box */
	(void)prefs_check_button_with_label_create(
			vbox,
			_("Use message box"),
			IS_USE_MSGBOX(),
			"use_msgbox",
			NULL, -1, -1, -1, -1);

	/* msgbox max msgs */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" Max # of messages "),
			(float)prefs.msgbox_max_msg, 0.0, 1024.0, 1.0, 1.0, 0,
			"msgbox_max_msg",
			table, 0, 1, 0, 1, 1, 2, 0, 1);

	/* msgbox del msgs */
	(void)prefs_spin_button_with_label_create(
			vbox,
			_(" % msgs to delete "),
			(float)prefs.msgbox_per_del, 0.0, 100.0, 1.0, 1.0, 0,
			"msgbox_per_del",
			table, 0, 1, 1, 2, 1, 2, 1, 2);

	/* stuff into parent */
	gtk_box_pack_start(GTK_BOX(parent), frame, FALSE, FALSE, 0);
} /* prefs_frame_msgbox_create */
#endif  /* #ifdef WANT_MSGBOX */


/*
 * PRIVATE: prefs_pulldown_with_label_create
 *
 * convenience routine for creating combo widget (pulldown widget with text)
 */
static GtkWidget *
prefs_pulldown_with_label_create(
	GtkWidget *parent,
	char *labeltext,
	GList *itemlist,
	char *prefname,
	int pos)
{
	GtkWidget *hbox, *tmp;

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, FALSE, 0);
	tmp = gtk_label_new(labeltext);
	gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, FALSE, 0);

	tmp = gtk_combo_new();
	gtk_combo_set_popdown_strings(GTK_COMBO(tmp), itemlist);

	if (pos >= 0)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(tmp)->entry),
				   (char *)g_list_nth_data(itemlist, pos));
	gtk_editable_select_region(GTK_EDITABLE(GTK_COMBO(tmp)->entry), 0, -1);
	gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, FALSE, 0);
	prefs_wgtopt_list_add(GTK_WIDGET(GTK_EDITABLE(GTK_COMBO(tmp)->entry)),
			      ComboType, itemlist, prefname);

	return tmp;
} /* prefs_pulldown_with_label_create */


/*
 * PRIVATE: prefs_check_button_with_label_create
 *
 * convenience routine for creating a check button and label, and then packing
 * them into a parent (box).
 */
static GtkWidget *
prefs_check_button_with_label_create(
	GtkWidget *parent,
	char *labeltext,
	long expr,
	char *prefname,
	GtkWidget *table,
	int lft1, int rht1, int top1, int bot1)
{
	GtkWidget *tmp;

	tmp = gtk_check_button_new_with_label(labeltext);
	if (table) {
		gtk_table_attach_defaults(GTK_TABLE(table),
					  tmp, lft1, rht1, top1, bot1);
	} else {
		gtk_box_pack_start(GTK_BOX(parent), tmp, FALSE, FALSE, 0);
	}
	if (expr)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(tmp), TRUE);
	prefs_wgtopt_list_add(tmp, ButtonType, NULL, prefname);

	return tmp;
} /* prefs_check_button_with_label_create */


/*
 * PRIVATE: prefs_spin_button_with_label_create
 *
 * convenience routine for creating a spin button and a label
 *
 * if 'table' is non-null, the label and spin button are placed into the table.
 */
static GtkWidget *
prefs_spin_button_with_label_create(
	GtkWidget *parent,
	char *labeltext,
	float adj_value,
	float adj_lower,
	float adj_upper,
	float adj_step_incr,
	float adj_page_incr,
	float adj_page_size,
	char *prefname,
	GtkWidget *table,
	int lft1, int rht1, int top1, int bot1,
	int lft2, int rht2, int top2, int bot2)
{
	GtkWidget *tmp, *entry, *hbox = NULL;
	GtkObject *adj;

	tmp = gtk_label_new(labeltext);
	adj = gtk_adjustment_new(adj_value, adj_lower, adj_upper,
				 adj_step_incr, adj_page_incr, adj_page_size);
	if (table) {
		gtk_misc_set_alignment(GTK_MISC(tmp), 0, 0.5);
		gtk_table_attach_defaults(GTK_TABLE(table),
					  tmp, lft1, rht1, top1, bot1);
	} else {
		hbox = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, FALSE, 0);
	}

	tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
	gtk_spin_button_set_wrap(GTK_SPIN_BUTTON(tmp), TRUE);
	gtk_widget_set_usize(tmp, 65, 0);
	if (table) {
		gtk_table_attach_defaults(GTK_TABLE(table),
					  tmp, lft2, rht2, top2, bot2);
	} else {
		gtk_box_pack_start(GTK_BOX(hbox), tmp, FALSE, TRUE, 0);
	}
	entry = GTK_WIDGET(&(GTK_SPIN_BUTTON(tmp)->entry));
	prefs_wgtopt_list_add(GTK_WIDGET(entry), EntryType, NULL, prefname);

	return tmp;
} /* prefs_spin_button_with_label_create */


#ifdef USE_TOOLBARS
/*
 * PRIVATE: prefs_radio_button_with_label_create
 *
 * convenience routine for creating a radio button and a label.
 */
static GtkWidget *
prefs_radio_button_with_label_create(
	GtkWidget *parent,
	GtkWidget *group,
	char *labeltext,
	long expr,
	char *prefname)
{
	GtkWidget *tmp;

	if (group != NULL)
		tmp = gtk_radio_button_new_with_label(gtk_radio_button_group(
				GTK_RADIO_BUTTON(group)), labeltext);
	else
		tmp = gtk_radio_button_new_with_label(NULL, labeltext);
	gtk_box_pack_start(GTK_BOX(parent), tmp, FALSE, FALSE, 0);
	if (expr)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(tmp), TRUE);
	prefs_wgtopt_list_add(tmp, ButtonType, NULL, prefname);

	return tmp;

} /* prefs_radio_button_with_label_create */
#endif	/* USE_TOOLBARS */


/*
 * PRIVATE: prefs_box_in_frame
 *
 * convenience routine for creating a box (vbox or hbox) packed inside a frame.
 * NOTE!!  this routine is slightly different from the other convenience
 * routines; this one returns two widgets instead of one: the frame widget,
 * as well as the vbox widget.
 */
static void
prefs_box_in_frame(
	char *frametext,
	int border_width,
	GtkWidget **frame,
	GtkWidget **box,
	bool_t is_vbox
	)
{
	*frame = gtk_frame_new(frametext);
	if (border_width > 0)
		gtk_container_border_width(GTK_CONTAINER(*frame), border_width);
	if (is_vbox)
		*box = gtk_vbox_new(FALSE, 0);
	else
		*box = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(*frame), *box);
} /* prefs_box_in_frame */


#endif	/* !USE_LIBGLADE */
/* the end */
