/****************************
  Login for ICQ v6-7 protocol (Oscar)
  Olivier Crete (c) 2001
  GnomeICU
*****************************/

#include "common.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "util.h"
#include "v7login.h"
#include "v7recv.h"

void v7_login_connected (GTcpSocket *socket, GInetAddr *ia,
                   GTcpSocketConnectAsyncStatus status, V7Connection *conn);
gboolean v7_login_handler (GIOChannel *source, GIOCondition condition,
                           V7Connection *conn);
gboolean v7_login_error_handler (GIOChannel *iochannel, GIOCondition condition,
                                 V7Connection *conn);

gboolean isconnecting = FALSE;

V7Connection *v7_new_login_session(void)
{

  V7Connection *conn;
#ifdef TRACE_FUNCTION
  g_print( "v7_new_login_session\n" );
#endif

  if (isconnecting)
    return NULL;
  isconnecting = TRUE;

  animate_on();

  conn = g_malloc0(sizeof(V7Connection));

  conn->gsocketasyncid = gnet_tcp_socket_connect_async( server, remote_port,
                        (GTcpSocketConnectAsyncFunc) v7_login_connected, conn);
  conn->last_reqid = 1;
  conn->status = NOT_CONNECTED;
  otherconnections = g_slist_append(otherconnections, conn);
  return conn;

}

void v7_login_connected (GTcpSocket *socket, GInetAddr *ia,
              GTcpSocketConnectAsyncStatus status, V7Connection *conn)
{

#ifdef TRACE_FUNCTION
  g_print( "v7_login_connected\n" );
#endif


  if (status != GTCP_SOCKET_CONNECT_ASYNC_STATUS_OK) {

    otherconnections = g_slist_remove(otherconnections, conn);

    g_free(conn);

    Current_Status = STATUS_OFFLINE;
    ready_set();
    animate_off();
    isconnecting = FALSE;
    return;
  }

  conn->gsocket = socket;
  
  conn->status = CONNECTING;

  conn->iochannel = gnet_tcp_socket_get_iochannel (socket);
  
  conn->in_watch = g_io_add_watch ( conn->iochannel, G_IO_IN|G_IO_PRI,
                                    (GIOFunc) v7_login_handler, conn);
  conn->err_watch = g_io_add_watch ( conn->iochannel,
                                     G_IO_ERR|G_IO_HUP|G_IO_NVAL,
                                     (GIOFunc) v7_login_error_handler, conn);
  
}

gboolean v7_login_error_handler (GIOChannel *iochannel, GIOCondition condition,
                                 V7Connection *conn)
{
#ifdef TRACE_FUNCTION
  g_print( "v7_login_error_handler\n" );
#endif
  icq_set_status_offline( NULL, NULL);
  return FALSE; /* FIXME: not sure which value to return -- menesis */
}

gboolean v7_login_handler (GIOChannel *iochannel, GIOCondition condition,
                     V7Connection *conn)
{
  V7Packet *packet;
  TLVstack *tlvs;
  gchar *tempstr, *portstr, *errormsg=NULL, *url=NULL;
  TLV *tmp, *uin, *addressport, *cookie, *tlv1, *tlv2 ;
  WORD errorno=0;
  int i, port;

  /* Used to "encrypt" the pass (by xoring it) */
  static const unsigned char XORtable[] = { 0xf3, 0x26, 0x81, 0xc4,
                                            0x39, 0x86, 0xdb, 0x92,
                                            0x71, 0xa3, 0xb9, 0xe6,
                                            0x53, 0x7a, 0x95, 0x7c };
  
#ifdef TRACE_FUNCTION
  g_print( "v7_login_handler\n" );
#endif


  /* If we dont have the whole packet stop here */
  if ((packet = read_flap(conn)) == NULL)
    return TRUE;

  
  if (packet->channel == 1 &&
      packet->len == 4  &&
      packet->data[0] == packet->data[1] == packet->data[2] == 0 &&
      packet->data[3] == 1) {

    /*  Lets create the packet */
    tlvs = new_tlvstack    ("\0\0\0\x01", 4);

    tempstr = g_strdup_printf("%d",our_info->uin); 
    add_tlv(tlvs, 0x01, tempstr, strlen(tempstr));
    g_free(tempstr);

    tempstr = g_strdup(passwd); 
    for(i = 0; i < strlen(passwd); i++)
      tempstr[i] = (tempstr[i] ^ XORtable[i%16]);
    add_tlv(tlvs, 0x02, tempstr, strlen(passwd));
    g_free(tempstr);

    /* tempstr = g_strdup_printf("ICQ Inc. - Product of ICQ (TM).2000b.4.63.1.3279.85"); */
    tempstr = g_strdup_printf("GnomeICU - Product of the GnomeICU hackers " VERSION);
    add_tlv(tlvs, 0x03, tempstr, strlen(tempstr));
    g_free(tempstr);

    add_tlv_w_be(tlvs, 0x16, 0x010A);      /* Type */
    add_tlv_w_be(tlvs, 0x17, 4);           /* Major Version */
    add_tlv_w_be(tlvs, 0x18, 63);          /* Minor Version */
    add_tlv_w_be(tlvs, 0x19,  1);          /* ICQ Number ??? */
    add_tlv_w_be(tlvs, 0x1A,  3279);       /* Build Major */
    add_tlv_dw_be(tlvs, 0x14, 85  );       /* Build Minor */
    add_tlv(tlvs, 0x0F, "en", 2);       /* Language ? */
    add_tlv(tlvs, 0x0E, "us", 2);       /* Country ? */
    
    if (! flap_send(conn, CHANNEL_NEWCONN, tlvs->beg, tlvs->len))
      conn->status = BROKEN;
    
    free_tlvstack(tlvs);
    
    return TRUE;
  } else if (packet->channel == 4) {
    uin = new_tlv(packet->data);
    
    if (uin->type != 1)
      conn->status = BROKEN;
    
    
    tmp = new_tlv(packet->data + uin->len+4);
    if (tmp->type == 5 || tmp->type == 6) {
      if (tmp->type == 5) {
        addressport = tmp;
        cookie = new_tlv(packet->data + uin->len+4 + tmp->len+4);
      } else {
        g_warning("Inversed order on login???\n");
        cookie = tmp;
        addressport =  new_tlv(packet->data + uin->len+4 + tmp->len+4);
      }
      
      portstr = strrchr(addressport->value, ':');
      *portstr++ = 0;
      
      port = strtol(portstr, NULL, 10);
      
      tempstr = g_strdup_printf("Connection to main server: %s",
                                addressport->value);
      g_free(tempstr);
      
      v7_connect(addressport->value, port, cookie->value, cookie->len);
      
      delete_tlv(addressport);
      delete_tlv(cookie);
    } else {
      tlv1 = new_tlv(packet->data + uin->len+4 );
      tlv2 =  new_tlv(packet->data + uin->len+4 + tlv1->len+4);

      switch(tlv1->type) {
      case 0x08:
        errorno = CharsBE_2_Word(tlv1->value);
        break;
      case 0x0B:
      case 0x04:
        url = tlv1->value;
        break;
      case 0x09:
      case 0x0C:        
      }
      
      switch(tlv2->type) {
      case 8:
        errorno = CharsBE_2_Word(tlv2->value);
        break;
      case 0x0B:
      case 0x04:
        url = tlv2->value;
        break;
      case 0x09:
      case 0x0C:
      }

      g_print("Errorno: %x\n", errorno);
      switch (errorno) {
      case 0x01:
        errormsg = g_strdup_printf(_("Error %x on connection: Bad UIN"),
                                   errorno);
        break;
      case 0x04:
      case 0x05:
        errormsg = g_strdup_printf(_("Error %x on connection: Wrong password"),
                                   errorno);
        break;
      case 0x07:
      case 0x08:
        errormsg = g_strdup_printf(_("Error %x on connection: Unknown UIN"),
                                   errorno);
        break;
      case 0x15:
      case 0x16:
        errormsg = g_strdup_printf(_("Error %x on connection:\n Too many clients from the same IP address"), errorno);
        break;
      case 0x18:
        errormsg = g_strdup_printf(_("Error %x on connection: Rate exceeded"),
                                   errorno);
        break;
      case 0x1E:
        errormsg = g_strdup_printf(_("Error %x on connection: please try again"),
                                   errorno);
        break;
      case 0x00:
        break;
      default:
        errormsg = g_strdup_printf(_("Error %x on connection: Unknown"),
                                   errorno);
      }

      if (url) {
        if (errormsg) {
          gchar *tmperror;
          tmperror = errormsg;
          errormsg = g_strdup_printf("%s\n%s", errormsg, url);
          g_free(tmperror);
        }
        else
          errormsg = g_strdup_printf("Unknown error\n %s", url);
      }
      
      if (errormsg) {
        gnome_error_dialog(errormsg);
        g_free(errormsg);
      }
      else 
        gnome_error_dialog("Very very bizzare error when connecting.\n");

      delete_tlv(tlv1);
      delete_tlv(tlv2);
      
      animate_off();
    }

    delete_tlv(uin);

    g_source_remove(conn->in_watch);
    g_source_remove(conn->err_watch);
    gnet_tcp_socket_delete(conn->gsocket);
    otherconnections = g_slist_remove(otherconnections, conn);
    g_free(conn);
    isconnecting = FALSE;
    return FALSE;

  } else {
    g_print("Something very abnormal hapenned\n");
  }  

  return TRUE;
}

