/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XStringForFSB
extends XString {
    int m_start;
    int m_length;
    protected String m_strCache = null;
    protected int m_hash = 0;

    public XStringForFSB(FastStringBuffer fastStringBuffer, int n2, int n3) {
        super(fastStringBuffer);
        this.m_start = n2;
        this.m_length = n3;
        if (null == fastStringBuffer) {
            throw new IllegalArgumentException("The FastStringBuffer argument can not be null!!");
        }
    }

    private XStringForFSB(String string) {
        super(string);
        throw new IllegalArgumentException("XStringForFSB can not take a string for an argument!");
    }

    public FastStringBuffer fsb() {
        return (FastStringBuffer)this.m_obj;
    }

    public void appendToFsb(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append(this.str());
    }

    public boolean hasString() {
        return null != this.m_strCache;
    }

    public Object object() {
        return this.str();
    }

    public String str() {
        if (null == this.m_strCache) {
            this.m_strCache = this.fsb().getString(this.m_start, this.m_length);
        }
        return this.m_strCache;
    }

    public void dispatchCharactersEvents(ContentHandler contentHandler) throws SAXException {
        this.fsb().sendSAXcharacters(contentHandler, this.m_start, this.m_length);
    }

    public void dispatchAsComment(LexicalHandler lexicalHandler) throws SAXException {
        this.fsb().sendSAXComment(lexicalHandler, this.m_start, this.m_length);
    }

    public int length() {
        return this.m_length;
    }

    public char charAt(int n2) {
        return this.fsb().charAt(this.m_start + n2);
    }

    public void getChars(int n2, int n3, char[] cArray, int n4) {
        int n5 = n3 - n2;
        if (n5 > this.m_length) {
            n5 = this.m_length;
        }
        if (n5 > cArray.length - n4) {
            n5 = cArray.length - n4;
        }
        int n6 = n2 + this.m_start + n5;
        int n7 = n4;
        FastStringBuffer fastStringBuffer = this.fsb();
        int n8 = n2 + this.m_start;
        while (n8 < n6) {
            cArray[n7++] = fastStringBuffer.charAt(n8);
            ++n8;
        }
    }

    public boolean equals(XMLString xMLString) {
        if (this == xMLString) {
            return true;
        }
        int n2 = this.m_length;
        if (n2 == xMLString.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n3 = this.m_start;
            int n4 = 0;
            while (n2-- != 0) {
                if (fastStringBuffer.charAt(n3) != xMLString.charAt(n4)) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
        return false;
    }

    public boolean equals(XObject xObject) {
        if (this == xObject) {
            return true;
        }
        int n2 = this.m_length;
        String string = xObject.str();
        if (n2 == string.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n3 = this.m_start;
            int n4 = 0;
            while (n2-- != 0) {
                if (fastStringBuffer.charAt(n3) != string.charAt(n4)) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
        return false;
    }

    public boolean equals(String string) {
        int n2 = this.m_length;
        if (n2 == string.length()) {
            FastStringBuffer fastStringBuffer = this.fsb();
            int n3 = this.m_start;
            int n4 = 0;
            while (n2-- != 0) {
                if (fastStringBuffer.charAt(n3) != string.charAt(n4)) {
                    return false;
                }
                ++n3;
                ++n4;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (object instanceof XNodeSet) {
            return object.equals(this);
        }
        if (object instanceof XStringForFSB) {
            return this.equals(this);
        }
        return this.equals(object.toString());
    }

    public boolean equalsIgnoreCase(String string) {
        return this.m_length == string.length() ? this.str().equalsIgnoreCase(string) : false;
    }

    public int compareTo(XMLString xMLString) {
        int n2 = this.m_length;
        int n3 = xMLString.length();
        int n4 = Math.min(n2, n3);
        FastStringBuffer fastStringBuffer = this.fsb();
        int n5 = this.m_start;
        int n6 = 0;
        while (n4-- != 0) {
            char c2;
            char c3 = fastStringBuffer.charAt(n5);
            if (c3 != (c2 = xMLString.charAt(n6))) {
                return c3 - c2;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public int compareToIgnoreCase(XMLString xMLString) {
        int n2 = this.m_length;
        int n3 = xMLString.length();
        int n4 = Math.min(n2, n3);
        FastStringBuffer fastStringBuffer = this.fsb();
        int n5 = this.m_start;
        int n6 = 0;
        while (n4-- != 0) {
            char c2;
            char c3 = Character.toLowerCase(fastStringBuffer.charAt(n5));
            if (c3 != (c2 = Character.toLowerCase(xMLString.charAt(n6)))) {
                return c3 - c2;
            }
            ++n5;
            ++n6;
        }
        return n2 - n3;
    }

    public int hashCode() {
        int n2 = this.m_hash;
        if (n2 == 0) {
            int n3 = this.m_start;
            int n4 = this.m_length;
            FastStringBuffer fastStringBuffer = this.fsb();
            int n5 = 0;
            while (n5 < n4) {
                n2 = 31 * n2 + fastStringBuffer.charAt(n3);
                ++n3;
                ++n5;
            }
            this.m_hash = n2;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(XMLString var1_1, int var2_2) {
        var3_3 = this.fsb();
        var4_4 = this.m_start + var2_2;
        var5_5 = this.m_start + this.m_length;
        var6_6 = 0;
        var7_7 = var1_1.length();
        if (var2_2 >= 0 && var2_2 <= this.m_length - var7_7) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            if (var3_3.charAt(var4_4) != var1_1.charAt(var6_6)) {
                return false;
            }
            ++var4_4;
            ++var6_6;
lbl12:
            // 2 sources

            ** while (--var7_7 >= 0)
        }
lbl13:
        // 1 sources

        return true;
    }

    public boolean startsWith(XMLString xMLString) {
        return this.startsWith(xMLString, 0);
    }

    public int indexOf(int n2) {
        return this.indexOf(n2, 0);
    }

    public int indexOf(int n2, int n3) {
        int n4 = this.m_start + this.m_length;
        FastStringBuffer fastStringBuffer = this.fsb();
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.m_length) {
            return -1;
        }
        int n5 = this.m_start + n3;
        while (n5 < n4) {
            if (fastStringBuffer.charAt(n5) == n2) {
                return n5 - this.m_start;
            }
            ++n5;
        }
        return -1;
    }

    public XMLString substring(int n2) {
        int n3 = this.m_length - n2;
        if (n3 <= 0) {
            return XString.EMPTYSTRING;
        }
        int n4 = this.m_start + n2;
        return new XStringForFSB(this.fsb(), n4, n3);
    }

    public XMLString substring(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 > this.m_length) {
            n4 = this.m_length;
        }
        if (n4 <= 0) {
            return XString.EMPTYSTRING;
        }
        int n5 = this.m_start + n2;
        return new XStringForFSB(this.fsb(), n5, n4);
    }

    public XMLString concat(String string) {
        return new XString(this.str().concat(string));
    }

    public XMLString trim() {
        return this.fixWhiteSpace(true, true, false);
    }

    private static boolean isSpace(char c2) {
        return XMLCharacterRecognizer.isWhiteSpace(c2);
    }

    public XMLString fixWhiteSpace(boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        int n3 = this.m_length + this.m_start;
        char[] cArray = new char[this.m_length];
        FastStringBuffer fastStringBuffer = this.fsb();
        boolean bl5 = false;
        int n4 = 0;
        boolean bl6 = false;
        int n5 = this.m_start;
        while (n5 < n3) {
            n2 = fastStringBuffer.charAt(n5);
            if (XStringForFSB.isSpace((char)n2)) {
                if (!bl6) {
                    if (32 != n2) {
                        bl5 = true;
                    }
                    cArray[n4++] = 32;
                    if (bl4 && n4 != 0) {
                        char c2 = cArray[n4 - 1];
                        if (c2 != '.' && c2 != '!' && c2 != '?') {
                            bl6 = true;
                        }
                    } else {
                        bl6 = true;
                    }
                } else {
                    bl5 = true;
                    bl6 = true;
                }
            } else {
                cArray[n4++] = n2;
                bl6 = false;
            }
            ++n5;
        }
        if (bl3 && 1 <= n4 && ' ' == cArray[n4 - 1]) {
            bl5 = true;
            --n4;
        }
        n2 = 0;
        if (bl2 && 0 < n4 && ' ' == cArray[0]) {
            bl5 = true;
            ++n2;
        }
        XMLStringFactory xMLStringFactory = XMLStringFactoryImpl.getFactory();
        return bl5 ? xMLStringFactory.newstr(cArray, n2, n4 - n2) : this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double toDouble() {
        int n2 = this.m_start;
        int n3 = this.m_length + n2;
        if (0 == n3) {
            return Double.NaN;
        }
        double d2 = 0.0;
        int n4 = n3 - 1;
        FastStringBuffer fastStringBuffer = this.fsb();
        int n5 = n2;
        while (n5 < n3) {
            char c2 = fastStringBuffer.charAt(n5);
            if (!XMLCharacterRecognizer.isWhiteSpace(c2)) break;
            ++n2;
            ++n5;
        }
        double d3 = 1.0;
        if (n2 < n3 && fastStringBuffer.charAt(n2) == '-') {
            d3 = -1.0;
            ++n2;
        }
        int n6 = 0;
        int n7 = n2;
        while (n7 < n3) {
            char c3 = fastStringBuffer.charAt(n7);
            if (c3 != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c3)) break;
                if (!Character.isDigit(c3)) return Double.NaN;
                d2 = d2 * 10.0 + (double)(c3 - 48);
                ++n6;
            } else {
                n4 = n7;
                break;
            }
            ++n7;
        }
        if (fastStringBuffer.charAt(n4) == '.') {
            double d4 = 0.0;
            int n8 = n3 - 1;
            while (n8 > n4) {
                char c4 = fastStringBuffer.charAt(n8);
                if (!XMLCharacterRecognizer.isWhiteSpace(c4)) {
                    if (!Character.isDigit(c4)) return Double.NaN;
                    d4 = d4 / 10.0 + (double)(c4 - 48);
                    ++n6;
                }
                --n8;
            }
            d2 += d4 / 10.0;
        }
        if (false != n6) return d2 * d3;
        return Double.NaN;
    }
}

