/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.text.JTextComponent;

public class MetalBorders {
    private static Border buttonBorder;
    private static Border textBorder;
    private static Border textFieldBorder;
    private static Border toggleButtonBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            textBorder = new BorderUIResource.CompoundBorderUIResource(new Flush3DBorder(), new BasicBorders.MarginBorder());
        }
        return textBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BasicBorders.MarginBorder());
        }
        return textFieldBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(), new BasicBorders.MarginBorder());
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new LineBorder(MetalLookAndFeel.getControlDarkShadow(), 1), new MatteBorder(2, 2, 1, 2, MetalLookAndFeel.getControl()));
    }

    public static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(2, 2, 2, 0);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(n4 - 1, 0, n4 - 1, n5 - 1);
            graphics.drawLine(1, n5 - 1, n4 - 1, n5 - 1);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(0, 0, n4 - 2, 0);
            graphics.drawLine(0, 0, 0, n5 - 2);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return this.editorBorderInsets;
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (!component.isEnabled()) {
                MetalUtils.drawDisabledBorder(graphics, n2, n3, n4 - 1, n5 - 1);
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                MetalUtils.drawPressed3DBorder(graphics, n2, n3, n4, n5);
            } else if (buttonModel.isSelected()) {
                MetalUtils.drawDark3DBorder(graphics, n2, n3, n4, n5);
            } else {
                MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
            }
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JScrollPane jScrollPane = (JScrollPane)component;
            JViewport jViewport = jScrollPane.getColumnHeader();
            int n6 = 0;
            if (jViewport != null) {
                n6 = jViewport.getHeight();
            }
            JViewport jViewport2 = jScrollPane.getRowHeader();
            int n7 = 0;
            if (jViewport2 != null) {
                n7 = jViewport2.getWidth();
            }
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawRect(0, 0, n4 - 2, n5 - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 1);
            graphics.drawLine(1, n5 - 1, n4 - 1, n5 - 1);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(n4 - 2, 2 + n6, n4 - 2, 2 + n6);
            graphics.drawLine(1 + n7, n5 - 2, 1 + n7, n5 - 2);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder {
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (!(component instanceof JTextComponent)) {
                if (component.isEnabled()) {
                    MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
                } else {
                    MetalUtils.drawDisabledBorder(graphics, n2, n3, n4, n5);
                }
                return;
            }
            if (component.isEnabled() && ((JTextComponent)component).isEditable()) {
                MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n2, n3, n4, n5);
            }
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        protected MetalBumps bumps = new MetalBumps(10, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getMenuBackground());

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    this.bumps.setBumpArea(10, component.getSize().height - 4);
                    if (MetalUtils.isLeftToRight(component)) {
                        this.bumps.paintIcon(component, graphics, 2, 2);
                    } else {
                        this.bumps.paintIcon(component, graphics, component.getBounds().width - 12, 2);
                    }
                } else {
                    this.bumps.setBumpArea(component.getSize().width - 4, 10);
                    this.bumps.paintIcon(component, graphics, 2, 2);
                }
            }
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2;
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            if (((JToolBar)component).isFloatable()) {
                if (((JToolBar)component).getOrientation() == 0) {
                    if (component.getComponentOrientation().isLeftToRight()) {
                        insets.left = 16;
                    } else {
                        insets.right = 16;
                    }
                } else {
                    insets.top = 16;
                }
            }
            if ((insets2 = ((JToolBar)component).getMargin()) != null) {
                insets.left += insets2.left;
                insets.top += insets2.top;
                insets.right += insets2.right;
                insets.bottom += insets2.bottom;
            }
            return insets;
        }
    }

    static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = null;
            if (component instanceof AbstractButton) {
                insets2 = ((AbstractButton)component).getMargin();
            }
            if (insets2 == null || insets2 instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = insets2.left;
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
            }
            return insets;
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isRollover() && (!buttonModel.isPressed() || buttonModel.isArmed())) {
                super.paintBorder(component, graphics, n2, n3, n4, n5);
            }
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawRect(0, 0, n4 - 1, n5 - 1);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 1, n4 - 2, 1);
            graphics.drawLine(1, 2, 1, 2);
            graphics.drawLine(1, n5 - 2, 1, n5 - 2);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = PopupMenuBorder.borderInsets.top;
            insets.left = PopupMenuBorder.borderInsets.left;
            insets.bottom = PopupMenuBorder.borderInsets.bottom;
            insets.right = PopupMenuBorder.borderInsets.right;
            return insets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n2, n3);
            if (component.getParent() instanceof JMenuBar) {
                if (buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, n4 - 2, 0);
                    graphics.drawLine(0, 0, 0, n5 - 1);
                    graphics.drawLine(n4 - 2, 2, n4 - 2, n5 - 1);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                    graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 1);
                    graphics.setColor(MetalLookAndFeel.getMenuBackground());
                    graphics.drawLine(n4 - 1, 0, n4 - 1, 0);
                }
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                graphics.drawLine(0, 0, n4 - 1, 0);
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, n5 - 1, n4 - 1, n5 - 1);
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
                graphics.drawLine(0, 0, 0, n5 - 1);
            }
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = MenuItemBorder.borderInsets.top;
            insets.left = MenuItemBorder.borderInsets.left;
            insets.bottom = MenuItemBorder.borderInsets.bottom;
            insets.right = MenuItemBorder.borderInsets.right;
            return insets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(0, n5 - 1, n4, n5 - 1);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = MenuBarBorder.borderInsets.top;
            insets.left = MenuBarBorder.borderInsets.left;
            insets.bottom = MenuBarBorder.borderInsets.bottom;
            insets.right = MenuBarBorder.borderInsets.right;
            return insets;
        }
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(3, 3, 3, 3);
        int titleHeight = 0;

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Object object;
            graphics.translate(n2, n3);
            int n6 = -1;
            if (component instanceof JInternalFrame && (object = ((JInternalFrame)component).getClientProperty("JInternalFrame.messageType")) != null && object instanceof Integer) {
                n6 = (Integer)object;
            }
            switch (n6) {
                case 0: {
                    object = UIManager.getColor("OptionPane.errorDialog.border.background");
                    break;
                }
                case 3: {
                    object = UIManager.getColor("OptionPane.questionDialog.border.background");
                    break;
                }
                case 2: {
                    object = UIManager.getColor("OptionPane.warningDialog.border.background");
                    break;
                }
                default: {
                    object = MetalLookAndFeel.getPrimaryControlDarkShadow();
                }
            }
            graphics.setColor((Color)object);
            graphics.drawLine(1, 0, n4 - 2, 0);
            graphics.drawLine(0, 1, 0, n5 - 2);
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 2);
            graphics.drawLine(1, n5 - 1, n4 - 2, n5 - 1);
            int n7 = 1;
            while (n7 < 3) {
                graphics.drawRect(n7, n7, n4 - n7 * 2 - 1, n5 - n7 * 2 - 1);
                ++n7;
            }
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = OptionDialogBorder.insets.top;
            insets.left = OptionDialogBorder.insets.left;
            insets.bottom = OptionDialogBorder.insets.bottom;
            insets.right = OptionDialogBorder.insets.right;
            return insets;
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);
        int titleHeight = 0;

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.translate(n2, n3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(0, 1, 0, n5 - 2);
            graphics.drawLine(1, n5 - 1, n4 - 2, n5 - 1);
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 2);
            graphics.drawLine(1, 0, n4 - 2, 0);
            graphics.drawRect(1, 1, n4 - 3, n5 - 3);
            graphics.translate(-n2, -n3);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = PaletteBorder.insets.top;
            insets.left = PaletteBorder.insets.left;
            insets.bottom = PaletteBorder.insets.bottom;
            insets.right = PaletteBorder.insets.right;
            return insets;
        }
    }

    static class WarningDialogBorder
    extends DialogBorder
    implements UIResource {
        WarningDialogBorder() {
        }

        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.warningDialog.border.background");
        }
    }

    static class QuestionDialogBorder
    extends DialogBorder
    implements UIResource {
        QuestionDialogBorder() {
        }

        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.questionDialog.border.background");
        }
    }

    static class ErrorDialogBorder
    extends DialogBorder
    implements UIResource {
        ErrorDialogBorder() {
        }

        protected Color getActiveBackground() {
            return UIManager.getColor("OptionPane.errorDialog.border.background");
        }
    }

    static class DialogBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int corner = 14;

        DialogBorder() {
        }

        protected Color getActiveBackground() {
            return MetalLookAndFeel.getPrimaryControlDarkShadow();
        }

        protected Color getActiveHighlight() {
            return MetalLookAndFeel.getPrimaryControlShadow();
        }

        protected Color getActiveShadow() {
            return MetalLookAndFeel.getPrimaryControlInfo();
        }

        protected Color getInactiveBackground() {
            return MetalLookAndFeel.getControlDarkShadow();
        }

        protected Color getInactiveHighlight() {
            return MetalLookAndFeel.getControlShadow();
        }

        protected Color getInactiveShadow() {
            return MetalLookAndFeel.getControlInfo();
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Color color;
            Color color2;
            Color color3;
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null && window.isActive()) {
                color3 = this.getActiveBackground();
                color2 = this.getActiveHighlight();
                color = this.getActiveShadow();
            } else {
                color3 = this.getInactiveBackground();
                color2 = this.getInactiveHighlight();
                color = this.getInactiveShadow();
            }
            graphics.setColor(color3);
            graphics.drawLine(n2 + 1, n3 + 0, n2 + n4 - 2, n3 + 0);
            graphics.drawLine(n2 + 0, n3 + 1, n2 + 0, n3 + n5 - 2);
            graphics.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n3 + n5 - 2);
            graphics.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 2, n3 + n5 - 1);
            int n6 = 1;
            while (n6 < 5) {
                graphics.drawRect(n2 + n6, n3 + n6, n4 - n6 * 2 - 1, n5 - n6 * 2 - 1);
                ++n6;
            }
            if (window instanceof Dialog && ((Dialog)window).isResizable()) {
                graphics.setColor(color2);
                graphics.drawLine(15, 3, n4 - 14, 3);
                graphics.drawLine(3, 15, 3, n5 - 14);
                graphics.drawLine(n4 - 2, 15, n4 - 2, n5 - 14);
                graphics.drawLine(15, n5 - 2, n4 - 14, n5 - 2);
                graphics.setColor(color);
                graphics.drawLine(14, 2, n4 - 14 - 1, 2);
                graphics.drawLine(2, 14, 2, n5 - 14 - 1);
                graphics.drawLine(n4 - 3, 14, n4 - 3, n5 - 14 - 1);
                graphics.drawLine(14, n5 - 3, n4 - 14 - 1, n5 - 3);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = DialogBorder.insets.top;
            insets.left = DialogBorder.insets.left;
            insets.bottom = DialogBorder.insets.bottom;
            insets.right = DialogBorder.insets.right;
            return insets;
        }
    }

    static class FrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int corner = 14;

        FrameBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            ColorUIResource colorUIResource3;
            Window window = SwingUtilities.getWindowAncestor(component);
            if (window != null && window.isActive()) {
                colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource = MetalLookAndFeel.getPrimaryControlInfo();
            } else {
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getControlShadow();
                colorUIResource = MetalLookAndFeel.getControlInfo();
            }
            graphics.setColor(colorUIResource3);
            graphics.drawLine(n2 + 1, n3 + 0, n2 + n4 - 2, n3 + 0);
            graphics.drawLine(n2 + 0, n3 + 1, n2 + 0, n3 + n5 - 2);
            graphics.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n3 + n5 - 2);
            graphics.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 2, n3 + n5 - 1);
            int n6 = 1;
            while (n6 < 5) {
                graphics.drawRect(n2 + n6, n3 + n6, n4 - n6 * 2 - 1, n5 - n6 * 2 - 1);
                ++n6;
            }
            if (window instanceof Frame && ((Frame)window).isResizable()) {
                graphics.setColor(colorUIResource2);
                graphics.drawLine(15, 3, n4 - 14, 3);
                graphics.drawLine(3, 15, 3, n5 - 14);
                graphics.drawLine(n4 - 2, 15, n4 - 2, n5 - 14);
                graphics.drawLine(15, n5 - 2, n4 - 14, n5 - 2);
                graphics.setColor(colorUIResource);
                graphics.drawLine(14, 2, n4 - 14 - 1, 2);
                graphics.drawLine(2, 14, 2, n5 - 14 - 1);
                graphics.drawLine(n4 - 3, 14, n4 - 3, n5 - 14 - 1);
                graphics.drawLine(14, n5 - 3, n4 - 14 - 1, n5 - 3);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = FrameBorder.insets.top;
            insets.left = FrameBorder.insets.left;
            insets.bottom = FrameBorder.insets.bottom;
            insets.right = FrameBorder.insets.right;
            return insets;
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int corner = 14;

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            ColorUIResource colorUIResource;
            ColorUIResource colorUIResource2;
            ColorUIResource colorUIResource3;
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isSelected()) {
                colorUIResource3 = MetalLookAndFeel.getPrimaryControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getPrimaryControlShadow();
                colorUIResource = MetalLookAndFeel.getPrimaryControlInfo();
            } else {
                colorUIResource3 = MetalLookAndFeel.getControlDarkShadow();
                colorUIResource2 = MetalLookAndFeel.getControlShadow();
                colorUIResource = MetalLookAndFeel.getControlInfo();
            }
            graphics.setColor(colorUIResource3);
            graphics.drawLine(1, 0, n4 - 2, 0);
            graphics.drawLine(0, 1, 0, n5 - 2);
            graphics.drawLine(n4 - 1, 1, n4 - 1, n5 - 2);
            graphics.drawLine(1, n5 - 1, n4 - 2, n5 - 1);
            int n6 = 1;
            while (n6 < 5) {
                graphics.drawRect(n2 + n6, n3 + n6, n4 - n6 * 2 - 1, n5 - n6 * 2 - 1);
                ++n6;
            }
            if (component instanceof JInternalFrame && ((JInternalFrame)component).isResizable()) {
                graphics.setColor(colorUIResource2);
                graphics.drawLine(15, 3, n4 - 14, 3);
                graphics.drawLine(3, 15, 3, n5 - 14);
                graphics.drawLine(n4 - 2, 15, n4 - 2, n5 - 14);
                graphics.drawLine(15, n5 - 2, n4 - 14, n5 - 2);
                graphics.setColor(colorUIResource);
                graphics.drawLine(14, 2, n4 - 14 - 1, 2);
                graphics.drawLine(2, 14, 2, n5 - 14 - 1);
                graphics.drawLine(n4 - 3, 14, n4 - 3, n5 - 14 - 1);
                graphics.drawLine(14, n5 - 3, n4 - 14 - 1, n5 - 3);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = InternalFrameBorder.insets.top;
            insets.left = InternalFrameBorder.insets.left;
            insets.bottom = InternalFrameBorder.insets.bottom;
            insets.right = InternalFrameBorder.insets.right;
            return insets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    MetalUtils.drawPressed3DBorder(graphics, n2, n3, n4, n5);
                } else if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton()) {
                    if (abstractButton.hasFocus()) {
                        // empty if block
                    }
                    MetalUtils.drawDefaultButtonBorder(graphics, n2, n3, n4, n5, false);
                } else {
                    if (abstractButton.hasFocus()) {
                        // empty if block
                    }
                    MetalUtils.drawButtonBorder(graphics, n2, n3, n4, n5, false);
                }
            } else {
                MetalUtils.drawDisabledBorder(graphics, n2, n3, n4 - 1, n5 - 1);
            }
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = ButtonBorder.borderInsets.top;
            insets.left = ButtonBorder.borderInsets.left;
            insets.bottom = ButtonBorder.borderInsets.bottom;
            insets.right = ButtonBorder.borderInsets.right;
            return insets;
        }
    }

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            if (component.isEnabled()) {
                MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
            } else {
                MetalUtils.drawDisabledBorder(graphics, n2, n3, n4, n5);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = Flush3DBorder.insets.top;
            insets.left = Flush3DBorder.insets.left;
            insets.bottom = Flush3DBorder.insets.bottom;
            insets.right = Flush3DBorder.insets.right;
            return insets;
        }
    }
}

