/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class HashSet
extends AbstractSet
implements Set,
Cloneable,
Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap map;
    private static final Object PRESENT = new Object();

    public HashSet() {
        this.map = new HashMap();
    }

    public HashSet(Collection collection) {
        this.map = new HashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public HashSet(int n2, float f2) {
        this.map = new HashMap(n2, f2);
    }

    public HashSet(int n2) {
        this.map = new HashMap(n2);
    }

    HashSet(int n2, float f2, boolean bl2) {
        this.map = new LinkedHashMap(n2, f2);
    }

    public Iterator iterator() {
        return this.map.keySet().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public boolean add(Object object) {
        return this.map.put(object, PRESENT) == null;
    }

    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            HashSet hashSet = (HashSet)super.clone();
            hashSet.map = (HashMap)this.map.clone();
            return hashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.map.capacity());
        objectOutputStream.writeFloat(this.map.loadFactor());
        objectOutputStream.writeInt(this.map.size());
        Iterator iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        float f2 = objectInputStream.readFloat();
        this.map = this instanceof LinkedHashSet ? new LinkedHashMap(n2, f2) : new HashMap(n2, f2);
        int n3 = objectInputStream.readInt();
        int n4 = 0;
        while (n4 < n3) {
            Object object = objectInputStream.readObject();
            this.map.put(object, PRESENT);
            ++n4;
        }
    }
}

