/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class RescaleOp
implements BufferedImageOp,
RasterOp {
    float[] scaleFactors;
    float[] offsets;
    int length = 0;
    RenderingHints hints;
    private int srcNbits;
    private int dstNbits;

    public RescaleOp(float[] fArray, float[] fArray2, RenderingHints renderingHints) {
        this.length = fArray.length;
        if (this.length > fArray2.length) {
            this.length = fArray2.length;
        }
        this.scaleFactors = new float[this.length];
        this.offsets = new float[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            this.scaleFactors[n2] = fArray[n2];
            this.offsets[n2] = fArray2[n2];
            ++n2;
        }
        this.hints = renderingHints;
    }

    public RescaleOp(float f2, float f3, RenderingHints renderingHints) {
        this.length = 1;
        this.scaleFactors = new float[1];
        this.offsets = new float[1];
        this.scaleFactors[0] = f2;
        this.offsets[0] = f3;
        this.hints = renderingHints;
    }

    public final float[] getScaleFactors(float[] fArray) {
        if (fArray == null) {
            return (float[])this.scaleFactors.clone();
        }
        System.arraycopy(this.scaleFactors, 0, fArray, 0, Math.min(this.scaleFactors.length, fArray.length));
        return fArray;
    }

    public final float[] getOffsets(float[] fArray) {
        if (fArray == null) {
            return (float[])this.offsets.clone();
        }
        System.arraycopy(this.offsets, 0, fArray, 0, Math.min(this.offsets.length, fArray.length));
        return fArray;
    }

    public final int getNumFactors() {
        return this.length;
    }

    private ByteLookupTable createByteLut(float[] fArray, float[] fArray2, int n2, int n3) {
        byte[][] byArray = new byte[fArray.length][n3];
        int n4 = 0;
        while (n4 < fArray.length) {
            float f2 = fArray[n4];
            float f3 = fArray2[n4];
            byte[] byArray2 = byArray[n4];
            int n5 = 0;
            while (n5 < n3) {
                int n6 = (int)((float)n5 * f2 + f3);
                if ((n6 & 0xFFFFFF00) != 0) {
                    n6 = n6 < 0 ? 0 : 255;
                }
                byArray2[n5] = (byte)n6;
                ++n5;
            }
            ++n4;
        }
        return new ByteLookupTable(0, byArray);
    }

    private ShortLookupTable createShortLut(float[] fArray, float[] fArray2, int n2, int n3) {
        short[][] sArray = new short[fArray.length][n3];
        int n4 = 0;
        while (n4 < fArray.length) {
            float f2 = fArray[n4];
            float f3 = fArray2[n4];
            short[] sArray2 = sArray[n4];
            int n5 = 0;
            while (n5 < n3) {
                int n6 = (int)((float)n5 * f2 + f3);
                if ((n6 & 0xFFFF0000) != 0) {
                    n6 = n6 < 0 ? 0 : 65535;
                }
                sArray2[n5] = (short)n6;
                ++n5;
            }
            ++n4;
        }
        return new ShortLookupTable(0, sArray);
    }

    private boolean canUseLookup(Raster raster, Raster raster2) {
        int n2 = raster.getDataBuffer().getDataType();
        if (n2 != 0 && n2 != 1) {
            return false;
        }
        SampleModel sampleModel = raster2.getSampleModel();
        this.dstNbits = sampleModel.getSampleSize(0);
        if (this.dstNbits != 8 && this.dstNbits != 16) {
            return false;
        }
        int n3 = 1;
        while (n3 < raster.getNumBands()) {
            int n4 = sampleModel.getSampleSize(n3);
            if (n4 != this.dstNbits) {
                return false;
            }
            ++n3;
        }
        SampleModel sampleModel2 = raster.getSampleModel();
        this.srcNbits = sampleModel2.getSampleSize(0);
        if (this.srcNbits > 16) {
            return false;
        }
        int n5 = 1;
        while (n5 < raster.getNumBands()) {
            int n6 = sampleModel2.getSampleSize(n5);
            if (n6 != this.srcNbits) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        ColorModel colorModel;
        ColorModel colorModel2 = bufferedImage.getColorModel();
        int n2 = colorModel2.getNumColorComponents();
        if (colorModel2 instanceof IndexColorModel) {
            throw new IllegalArgumentException("Rescaling cannot be performed on an indexed image");
        }
        if (this.length != 1 && this.length != n2 && this.length != colorModel2.getNumComponents()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of color or color/alpha  components");
        }
        boolean bl2 = false;
        if (this.length > n2 && colorModel2.hasAlpha()) {
            this.length = n2 + 1;
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            colorModel = colorModel2;
        } else {
            if (n3 != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Src width (" + n3 + ") not equal to dst width (" + bufferedImage2.getWidth() + ")");
            }
            if (n4 != bufferedImage2.getHeight()) {
                throw new IllegalArgumentException("Src height (" + n4 + ") not equal to dst height (" + bufferedImage2.getHeight() + ")");
            }
            colorModel = bufferedImage2.getColorModel();
            if (colorModel2.getColorSpace().getType() != colorModel.getColorSpace().getType()) {
                bl2 = true;
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        BufferedImage bufferedImage3 = bufferedImage2;
        if (ImagingLib.filter(this, bufferedImage, bufferedImage2) == null) {
            int n5;
            int n6;
            object = bufferedImage.getRaster();
            WritableRaster writableRaster = bufferedImage2.getRaster();
            if (colorModel2.hasAlpha() && (n2 - 1 == this.length || this.length == 1)) {
                n6 = ((Raster)object).getMinX();
                n5 = ((Raster)object).getMinY();
                int[] nArray = new int[n2 - 1];
                int n7 = 0;
                while (n7 < n2 - 1) {
                    nArray[n7] = n7;
                    ++n7;
                }
                object = ((WritableRaster)object).createWritableChild(n6, n5, ((Raster)object).getWidth(), ((Raster)object).getHeight(), n6, n5, nArray);
            }
            if (colorModel.hasAlpha() && ((n6 = writableRaster.getNumBands()) - 1 == this.length || this.length == 1)) {
                n5 = writableRaster.getMinX();
                int n8 = writableRaster.getMinY();
                int[] nArray = new int[n2 - 1];
                int n9 = 0;
                while (n9 < n2 - 1) {
                    nArray[n9] = n9;
                    ++n9;
                }
                writableRaster = writableRaster.createWritableChild(n5, n8, writableRaster.getWidth(), writableRaster.getHeight(), n5, n8, nArray);
            }
            this.filter((Raster)object, writableRaster);
        }
        if (bl2) {
            object = new ColorConvertOp(this.hints);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        }
        return bufferedImage3;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n2 = raster.getNumBands();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int[] nArray = null;
        int n5 = 0;
        int n6 = 0;
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else {
            if (n4 != writableRaster.getHeight() || n3 != writableRaster.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (n2 != writableRaster.getNumBands()) {
                throw new IllegalArgumentException("Number of bands in src " + n2 + " does not equal number of bands in dest " + writableRaster.getNumBands());
            }
        }
        if (this.length != 1 && this.length != raster.getNumBands()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of bands in the src raster");
        }
        if (ImagingLib.filter(this, raster, writableRaster) != null) {
            return writableRaster;
        }
        if (this.canUseLookup(raster, writableRaster)) {
            int n7 = 1 << this.srcNbits;
            int n8 = 1 << this.dstNbits;
            if (n8 == 256) {
                ByteLookupTable byteLookupTable = this.createByteLut(this.scaleFactors, this.offsets, n2, n7);
                LookupOp lookupOp = new LookupOp(byteLookupTable, this.hints);
                lookupOp.filter(raster, writableRaster);
            } else {
                ShortLookupTable shortLookupTable = this.createShortLut(this.scaleFactors, this.offsets, n2, n7);
                LookupOp lookupOp = new LookupOp(shortLookupTable, this.hints);
                lookupOp.filter(raster, writableRaster);
            }
        } else {
            if (this.length > 1) {
                n5 = 1;
            }
            int n9 = raster.getMinX();
            int n10 = raster.getMinY();
            int n11 = writableRaster.getMinX();
            int n12 = writableRaster.getMinY();
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            SampleModel sampleModel = writableRaster.getSampleModel();
            int n13 = 0;
            while (n13 < n2) {
                int n14 = sampleModel.getSampleSize(n13);
                nArray2[n13] = (1 << n14) - 1;
                nArray3[n13] = ~nArray2[n13];
                ++n13;
            }
            int n15 = 0;
            while (n15 < n4) {
                int n16 = n11;
                int n17 = n9;
                int n18 = 0;
                while (n18 < n3) {
                    nArray = raster.getPixel(n17, n10, nArray);
                    n6 = 0;
                    int n19 = 0;
                    while (n19 < n2) {
                        int n20 = (int)((float)nArray[n19] * this.scaleFactors[n6] + this.offsets[n6]);
                        if ((n20 & nArray3[n19]) != 0) {
                            n20 = n20 < 0 ? 0 : nArray2[n19];
                        }
                        nArray[n19] = n20;
                        ++n19;
                        n6 += n5;
                    }
                    writableRaster.setPixel(n16, n12, nArray);
                    ++n18;
                    ++n17;
                    ++n16;
                }
                ++n15;
                ++n10;
                ++n12;
            }
        }
        return writableRaster;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            bufferedImage2 = new BufferedImage(colorModel2, bufferedImage.getRaster().createCompatibleWritableRaster(), colorModel2.isAlphaPremultiplied(), null);
        } else {
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n2, n3), colorModel.isAlphaPremultiplied(), null);
        }
        return bufferedImage2;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight());
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

