/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;

public class ServerSocket {
    private static SocketImplFactory factory;
    private SocketImpl impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();

    private ServerSocket() {
    }

    public ServerSocket(int port) throws IOException {
        this(port, 50);
    }

    public ServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, null);
    }

    public ServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
        this();
        if (this.impl == null) {
            throw new IOException("Cannot initialize Socket implementation");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(port);
        }
        if (bindAddr == null) {
            bindAddr = InetAddress.ANY_IF;
        }
        this.impl.create(true);
        this.impl.bind(bindAddr, port);
        this.impl.listen(backlog);
    }

    public InetAddress getInetAddress() {
        return this.impl.getInetAddress();
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public Socket accept() throws IOException {
        Socket s = new Socket();
        this.implAccept(s);
        return s;
    }

    protected final void implAccept(Socket s) throws IOException {
        this.impl.accept(s.impl);
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("SO_TIMEOUT value must be >= 0");
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public int getSoTimeout() throws IOException {
        Object timeout = this.impl.getOption(4102);
        if (!(timeout instanceof Integer)) {
            throw new IOException("Internal Error");
        }
        return (Integer)timeout;
    }

    public String toString() {
        return "ServerSocket " + this.impl.toString();
    }

    public static synchronized void setSocketFactory(SocketImplFactory fac) throws IOException {
        factory = fac;
    }
}

