/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class MulticastSocket
extends DatagramSocket {
    public MulticastSocket() throws IOException {
        super(0, null);
    }

    public MulticastSocket(int port) throws IOException {
        super(port, null);
    }

    public InetAddress getInterface() throws SocketException {
        return (InetAddress)this.impl.getOption(16);
    }

    public byte getTTL() throws IOException {
        return this.impl.getTTL();
    }

    public int getTimeToLive() throws IOException {
        return this.impl.getTimeToLive();
    }

    public void setInterface(InetAddress inf) throws SocketException {
        this.impl.setOption(16, inf);
    }

    public void setTTL(byte ttl) throws IOException {
        this.impl.setTTL(ttl);
    }

    public void setTimeToLive(int ttl) throws IOException {
        if (ttl <= 0 || ttl > 255) {
            throw new IllegalArgumentException("Invalid ttl: " + ttl);
        }
        this.impl.setTimeToLive(ttl);
    }

    public void joinGroup(InetAddress mcastaddr) throws IOException {
        if (!mcastaddr.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(mcastaddr);
        }
        this.impl.join(mcastaddr);
    }

    public void leaveGroup(InetAddress mcastaddr) throws IOException {
        if (!mcastaddr.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkMulticast(mcastaddr);
        }
        this.impl.leave(mcastaddr);
    }

    public synchronized void send(DatagramPacket p, byte ttl) throws IOException {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            InetAddress addr = p.getAddress();
            if (addr.isMulticastAddress()) {
                s.checkMulticast(addr, ttl);
            } else {
                s.checkConnect(addr.getHostAddress(), p.getPort());
            }
        }
        int oldttl = this.impl.getTimeToLive();
        this.impl.setTimeToLive(ttl & 0xFF);
        this.impl.send(p);
        this.impl.setTimeToLive(oldttl);
    }
}

