/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import java.security.SecurityPermission;

public class SecurityManager {
    protected boolean inCheck;

    public boolean getInCheck() {
        return this.inCheck;
    }

    protected Class[] getClassContext() {
        return VMSecurityManager.getClassContext();
    }

    protected ClassLoader currentClassLoader() {
        return VMSecurityManager.currentClassLoader();
    }

    protected Class currentLoadedClass() {
        Class[] c = this.getClassContext();
        for (int i = 0; i < c.length; ++i) {
            if (c[i].getClassLoader() == null) continue;
            return c[i];
        }
        return null;
    }

    protected int classLoaderDepth() {
        Class[] c = this.getClassContext();
        for (int i = 0; i < c.length; ++i) {
            if (c[i].getClassLoader() == null) continue;
            return i;
        }
        return -1;
    }

    protected boolean inClassLoader() {
        return this.classLoaderDepth() != -1;
    }

    protected int classDepth(String className) {
        Class[] c = this.getClassContext();
        for (int i = 0; i < c.length; ++i) {
            if (!className.equals(c[i].getName())) continue;
            return i;
        }
        return -1;
    }

    protected boolean inClass(String className) {
        return this.classDepth(className) != -1;
    }

    public Object getSecurityContext() {
        return new SecurityContext(this.getClassContext());
    }

    public void checkCreateClassLoader() {
        throw new SecurityException("Cannot create new ClassLoaders.");
    }

    public void checkAccess(Thread t) {
        throw new SecurityException("Cannot modify Threads.");
    }

    public void checkAccess(ThreadGroup g) {
        throw new SecurityException("Cannot modify ThreadGroups.");
    }

    public void checkExit(int status) {
        throw new SecurityException("Cannot exit JVM.");
    }

    public void checkExec(String program) {
        throw new SecurityException("Cannot execute programs.");
    }

    public void checkLink(String filename) {
        throw new SecurityException("Cannot link native libraries.");
    }

    public void checkRead(FileDescriptor desc) {
        throw new SecurityException("Cannot read files via file descriptors.");
    }

    public void checkRead(String filename) {
        throw new SecurityException("Cannot read files via file names.");
    }

    public void checkRead(String filename, Object securityContext) {
        throw new SecurityException("Cannot read files via file names.");
    }

    public void checkWrite(FileDescriptor desc) {
        throw new SecurityException("Cannot write files via file descriptors.");
    }

    public void checkWrite(String filename) {
        throw new SecurityException("Cannot write files via file names.");
    }

    public void checkDelete(String filename) {
        throw new SecurityException("Cannot delete files.");
    }

    public void checkConnect(String host, int port) {
        throw new SecurityException("Cannot make network connections.");
    }

    public void checkConnect(String host, int port, Object securityContext) {
        throw new SecurityException("Cannot make network connections.");
    }

    public void checkListen(int port) {
        throw new SecurityException("Cannot listen for connections.");
    }

    public void checkAccept(String host, int port) {
        throw new SecurityException("Cannot accept connections.");
    }

    public void checkMulticast(InetAddress addr) {
        throw new SecurityException("Cannot read or write multicast.");
    }

    public void checkMulticast(InetAddress addr, byte ttl) {
        throw new SecurityException("Cannot read or write multicast.");
    }

    public void checkPermission(Permission perm) {
        throw new SecurityException("Operation not allowed");
    }

    public void checkPermission(Permission perm, Object context) {
        throw new SecurityException("Operation not allowed");
    }

    public void checkPropertiesAccess() {
        throw new SecurityException("Cannot access all system properties at once.");
    }

    public void checkPropertyAccess(String name) {
        throw new SecurityException("Cannot access individual system properties.");
    }

    public boolean checkTopLevelWindow(Object window) {
        return false;
    }

    public void checkPrintJobAccess() {
        throw new SecurityException("Cannot create print jobs.");
    }

    public void checkSystemClipboardAccess() {
        throw new SecurityException("Cannot access the system clipboard.");
    }

    public void checkAwtEventQueueAccess() {
        throw new SecurityException("Cannot access the AWT event queue.");
    }

    public void checkPackageAccess(String packageName) {
        throw new SecurityException("Cannot access packages via the ClassLoader.");
    }

    public void checkPackageDefinition(String packageName) {
        throw new SecurityException("Cannot load classes into any packages via the ClassLoader.");
    }

    public void checkSetFactory() {
        throw new SecurityException("Cannot set the socket factory.");
    }

    public void checkMemberAccess(Class c, int memberType) {
        throw new SecurityException("Cannot access members of classes.");
    }

    public void checkSecurityAccess(String action) {
        this.checkPermission(new SecurityPermission(action));
    }

    public ThreadGroup getThreadGroup() {
        return Thread.currentThread().getThreadGroup();
    }

    public SecurityManager() {
        if (System.getSecurityManager() != null) {
            throw new SecurityException();
        }
    }
}

