/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final int size() {
        return this.written;
    }

    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        this.out.write(b, off, len);
        this.written += len;
    }

    public final void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    public final void writeByte(int v) throws IOException {
        this.write(v & 0xFF);
    }

    public final void writeShort(int v) throws IOException {
        this.write((byte)(v >> 8) & 0xFFFFFFFF);
        this.write((byte)v & 0xFFFFFFFF);
    }

    public final void writeChar(int v) throws IOException {
        this.write((byte)(v >> 8) & 0xFFFFFFFF);
        this.write((byte)v & 0xFFFFFFFF);
    }

    public final void writeInt(int v) throws IOException {
        this.write((byte)(v >> 24) & 0xFFFFFFFF);
        this.write((byte)(v >> 16) & 0xFFFFFFFF);
        this.write((byte)(v >> 8) & 0xFFFFFFFF);
        this.write((byte)v & 0xFFFFFFFF);
    }

    public final void writeLong(long v) throws IOException {
        this.write((byte)(v >> 56) & 0xFFFFFFFF);
        this.write((byte)(v >> 48) & 0xFFFFFFFF);
        this.write((byte)(v >> 40) & 0xFFFFFFFF);
        this.write((byte)(v >> 32) & 0xFFFFFFFF);
        this.write((byte)(v >> 24) & 0xFFFFFFFF);
        this.write((byte)(v >> 16) & 0xFFFFFFFF);
        this.write((byte)(v >> 8) & 0xFFFFFFFF);
        this.write((byte)v & 0xFFFFFFFF);
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
    }

    public final void writeChars(String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s.charAt(i));
        }
    }

    public final void writeUTF(String s) throws IOException {
        char c;
        int i;
        int len = s.length();
        int sum = 0;
        for (i = 0; i < len && sum <= 65535; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++sum;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                sum += 2;
                continue;
            }
            sum += 3;
        }
        if (sum > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(sum);
        for (i = 0; i < len; ++i) {
            c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                this.write(0xC0 | 0x1F & c >> 6);
                this.write(0x80 | 0x3F & c);
                continue;
            }
            this.write(0xE0 | 0xF & c >> 12);
            this.write(0x80 | 0x3F & c >> 6);
            this.write(0x80 | 0x3F & c);
        }
    }
}

