#include <errno.h>

extern int errno;

#define SVR3_DEVS 0
#define SVR4_DEVS 1

#define LINUX_DEV
#define NODEV (-1)

/* For now, we feed device numbers in a linux format.  This is inconsistent
   with xmknod in the ibcs module right now, and this needs to be harmonized
*/

int __makedev(unsigned int vers, unsigned int major, 
		       unsigned int minor)
{
  unsigned int dev;
  if(major > 0xff || minor > 0xff) {errno = EINVAL; return NODEV;};

#ifdef LINUX_DEV
    dev = (major << 8) | minor;
#else
  if(vers == SVR3_DEVS) {
    dev = (major << 8) | minor;
  } else if (vers == SVR4_DEVS) {
    dev = (major << 18) | minor;
  } else {
    errno = EINVAL; return NODEV;
  };
#endif

  if(dev == NODEV) {errno = EINVAL; return NODEV;};
  return dev;
    
}


int __major(unsigned int vers, unsigned int dev)
{
  if(dev == NODEV) {errno = EINVAL; return NODEV;}; 
#ifdef LINUX_DEV
    return (dev >> 8);
#else
  if(vers == SVR3_DEVS)
    return (dev >> 8);
  if(vers == SVR4_DEVS)
    return (dev >> 18);
  errno = EINVAL;
  return NODEV;
#endif
}

int __minor(unsigned int vers, unsigned int dev)
{
  if(dev == NODEV) {errno = EINVAL; return NODEV;}; 
#ifdef LINUX_DEV
    return (dev & 0xff);
#else
  if(vers == SVR3_DEVS)
    return (dev & 0xff);
  if(vers == SVR4_DEVS)
    return (dev & 0x3ffff);
  errno = EINVAL;
  return NODEV;
#endif
}

