#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>

/***************************************************************************
 *
 * Function:    vprintf
 *
 * Description:
 *     Formatted print data to the stdout stream using variable arguments.
 *
 * Input:
 *     format   - pointer to the format string
 *     ap       - variable arg list pointer
 *
 * Result:
 *     The number of characters written to the output.
 */

int vprintf (const char *pszFormat, va_list ap)
    {
    int     fBuffering;
    int     nAnswer;
    FUNC_ENTRY ("vprintf");
/*
 *  Ensure that the file is fully buffered and edit the output stream.
 */
    fBuffering = _stbuf (stdout);
/*
 *  Output the stream
 */
    nAnswer = _doprnt (pszFormat, ap, stdout);
/*
 *  Restore the buffering state and return the number of characters
 *  written to the output file.
 */
    _ftbuf (fBuffering, stdout);
    FUNC_EXIT ("vprintf");
    return(nAnswer);
    }
