#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>

/***************************************************************************
 *
 * Function:     getw
 *
 * Description:
 *    This is yet another non-portable routine to read a single word from
 *    the input. The problem is that a "word" is not defined in size. However,
 *    this is a required routine.
 *
 *    For iBCS, this is always 4 bytes.
 *
 * Entry:
 *    stream   - Pointer to the input stream
 *
 * Returns:
 *    The input word or -1 to indicate a possible error condition.
 */

#ifdef ELF_LIBRARY
#define putw _putw
#endif

int putw (int nWord, FILE *stream)
    {
    int nIndex;
    unsigned char uchBuffer [sizeof (int)];
    int nValue = nWord;
    FUNC_ENTRY ("putw");
/*
 *  Decompose the word so that it may be written in "little endian" format
 *  always.
 */
    for (nIndex = 0; nIndex < sizeof (int); ++nIndex)
        {
	uchBuffer [nIndex] = (unsigned char) nValue;
	nValue >>= 8;
        }
/*
 *  Write the word to the output now that it has been converted to a
 *  buffer in the proper byte order.
 */
    for (nIndex = 0; nIndex < sizeof (int); ++nIndex)
        {
	if (putc (uchBuffer [nIndex], stream) == EOF)
	    {
	    nWord = EOF;
	    break;
	    }
        }
/*
 *  Return the input word or EOF as appropriate
 */
    FUNC_EXIT ("putw");
    return (nWord);
    }

#ifdef ELF_LIBRARY
__asm__(".weak putw; putw = _putw");
#endif
