#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/***************************************************************************
 *
 * Function:    printf
 *
 * Description:
 *     Formatted print data to the stdout stream
 *
 * Input:
 *     format   - pointer to the format string
 *     ep       - pointer to the output strings
 *
 * Result:
 *     The number of characters written to the output.
 */

int printf (const char *pszFormat, ...)
    {
    va_list vaArg;
    int     fBuffering;
    int     nAnswer;
    FUNC_ENTRY ("printf");
/*
 *  Ensure that the file is fully buffered and edit the output stream.
 */
    fBuffering = _stbuf (stdout);
/*
 *  Output the stream
 */
    va_start (vaArg, pszFormat);
    nAnswer = _doprnt (pszFormat, vaArg, stdout);
    va_end (vaArg);
/*
 *  Restore the buffering state and return the number of characters
 *  written to the output file.
 */
    _ftbuf (fBuffering, stdout);
    FUNC_EXIT ("printf");
    return(nAnswer);
    }
