#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>
/**************************************************************************
 *
 * Function:   flushall
 *
 * Description:
 *     This function will flush all pending buffers to the output file.
 *
 * Entry:
 *      none.
 *
 * Exit:
 *      The number of files which were flushed without error.
 */

int flushall (void)
    {
    FILE *stream = &_iob[0];
    int count    = 0;

    FUNC_ENTRY ("flushall");
    while (stream <= _lastiob)
        {
        if (inuse(stream))
            {
            if (fflush(stream) != EOF)
                {
                ++count;
	        }
	    }
        ++stream;
        }
/*
 *  Return the count of files which were flushed to the output
 */
    FUNC_EXIT ("flushall");
    return (count);
    }
