#ifndef _FCNTL_H
#define _FCNTL_H
/*
 * fcntl.h     iBCS compatable header
 */

#define O_RDONLY         0
#define O_WRONLY         1
#define O_RDWR           2
#define O_NDELAY         0x04
#define O_APPEND         0x08
#define O_SYNC           0x10
#define O_NONBLOCK       0x80
#define O_CREAT          0x100
#define O_TRUNC          0x200
#define O_EXCL           0x400
#define O_NOCTTY         0x800

#define F_DUPFD          0
#define F_GETFD          1
#define F_SETFD          2
#define F_GETFL          3
#define F_SETFL          4
#define F_GETLK          5
#define F_SETLK          6
#define F_SETLKW         7

typedef struct flock {
        short     l_type;
        short     l_whence;
        long      l_start;
        long      l_len;
        short     l_sysid;
        short     l_pid;
} flock_t;

#define F_RDLCK          01
#define F_WRLCK          02
#define F_UNLCK          03

#define O_ACCMODE        3
#define FD_CLOEXEC       1
#endif
