/*
 *	@(#)dirent.h	iBCS compatable header entry
 */

#ifndef _DIRENT_H_
#define _DIRENT_H_

/*
 * A directory entry has a struct dirent at the front of it, containing its
 * inode number, the length of the entry, and the length of the name
 * contained in the entry.  These are followed by the name padded to a 4
 * byte boundary with null bytes.  All names are guaranteed null terminated.
 * The maximum length of a name in a directory is MAXNAMLEN.
 */

#define MAXNAMLEN          512
#define DIRBUF             1048

struct dirent {
        u_long  d_ino;                  /* INODE number of the entry */
        off_t   d_off;                  /* Offset to the name field */
        u_short d_reclen;               /* Length of the current entry */
        char    d_name [1];             /* name entry */
};

typedef struct {
        int     dd_fd;                  /* File descriptor to the file */
        int     dd_loc;                 /* Current cursor value */
        int     dd_size;                /* Size of the buffer */
        char    *dd_buf;                /* Pointer to the buffer area */
} DIR;

#ifndef KERNEL
#include <sys/cdefs.h>

__BEGIN_DECLS
DIR *opendir (const char *);
struct dirent *readdir (DIR *);
void rewinddir (DIR *);
int closedir (DIR *);
long telldir (const DIR *);
void seekdir (DIR *, long);
int scandir (const char *, struct dirent ***,
    int (*)(struct dirent *), int (*)(const void *, const void *));
int alphasort (const void *, const void *);
int getdirentries (int, char *, int, long *);
__END_DECLS

#endif /* !KERNEL */

#endif /* !_DIRENT_H_ */
