/* Run an ELF binary on a linux system.

   Copyright (C) 1993, Eric Youngdale.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */



/* Various symbol table handling functions, including symbol lookup */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef IBCS_COMPATIBLE
#include <ibcs/unistd.h>
#else
#include <linux/unistd.h>
#endif
#include "hash.h"
#include "linuxelf.h"
#include "syscall.h"
#include "string.h"

unsigned long elf_hash(const char * name){
  unsigned long hash = 0;
  unsigned long tmp;

  while (*name){
    hash = (hash << 4) + *name++;
    if((tmp = hash & 0xf0000000)) hash ^= tmp >> 24;
    hash &= ~tmp;
  };
  return hash;
}

