/* 
 * This file Copyright (C) 2010 Christopher Stamm
 *                              Fachhochschule Nordwestschweiz 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU LESSER GENERAL PUBLIC LICENSE
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#pragma once

#include "PGFimage.h"
#include <iostream>

///////////////////////////////////////////////////////////////////////////////////
// CPNM: PNM image document class. Supports PBM, PGM, and PPM images.
class CPNM {
	// attributes 
	UINT8 *m_buffer;		// uncompressed image buffer
	int m_pitch;			// number of bytes per row
	int m_w, m_h;			// width and height in pixel
	int m_mode;				// image type
	int m_bpp;				// bits per pixel
	int m_maxValue;		// maximum value in image data

protected:
	// operations
	bool ReadP1(std::istream& in);
	bool ReadP2(std::istream& in);
	bool ReadP3(std::istream& in);
	bool ReadP4(std::istream& in);
	bool ReadP5(std::istream& in);
	bool ReadP6(std::istream& in);

	bool WriteP1(std::ostream& out);
	bool WriteP2(std::ostream& out);
	bool WriteP3(std::ostream& out);
	bool WriteP4(std::ostream& out);
	bool WriteP5(std::ostream& out);
	bool WriteP6(std::ostream& out);

public:
	CPNM();
	virtual ~CPNM();

	bool ReadPNM(CPGFImage& pgf, int quality, int levels, bool roi, bool alpha);
	bool WritePNM(CPGFImage& pgf, bool roi, PGFRect& rect, bool binary = true);

	// class methods
	static bool ReadMagic(std::istream& in, int& type);
	static bool ReadSize(std::istream& in, int& width, int& height);
	static bool ReadMaxValue(std::istream& in, int& maxValue);
	static bool ImportIsSupported(BYTE mode);
	static void FillInColorTable(RGBQUAD* table, int size);
	static void SkipComments(std::istream& in);
};

