.TH gccmakedep 1 __vendorversion__
.SH NAME
gccmakedep \- create dependencies in makefiles using 'gcc -M'
.SH SYNOPSIS
.B gccmakedep
[
.BI \-s separator
] [
.BI \-f makefile
] [
.BI \-a
] [
\-\^\-
.I options
\-\^\-
]
.I sourcefile
\&.\|.\|.
.SH DESCRIPTION
The
.B gccmakedep
program calls 'gcc -M' to output
.I makefile
rules describing the dependencies of each
.IR sourcefile ,
so that
.BR make (1)
knows which object files must be recompiled when a dependency has changed.
.PP
By default,
.B gccmakedep
places its output in the file named
.I makefile
if it exists, otherwise
.I Makefile.
An alternate makefile may be specified with the
.B \-f
option.
It first searches the makefile for a line beginning with
.sp
\&    # DO NOT DELETE
.sp
or one provided with the
.B \-s
option, as a delimiter for the dependency output.
If it finds it, it will delete everything following this up to the end of
the makefile and put the output after this line.
If it doesn't find it, the program will append the string to the makefile
and place the output after that.
.SH EXAMPLE
Normally,
.B gccmakedep
will be used in a makefile target so that typing 'make depend' will bring
the dependencies up to date for the makefile.
For example,
.nf
    SRCS\0=\0file1.c\0file2.c\0.\|.\|.
    CFLAGS\0=\0\-O\0\-DHACK\0\-I\^.\^.\^/foobar\0\-xyz
    depend:
            gccmakedep\0\-\^\-\0$(CFLAGS)\0\-\^\-\0$(SRCS)
.fi
.SH OPTIONS
The program will ignore any option that it does not understand, so you may
use the same arguments that you would for
.BR gcc (1),
including
.B \-D
and
.B \-U
options to define and undefine symbols and
.B \-I
to set the include path.
.TP
.B \-a
Append the dependencies to the file instead of replacing existing
dependencies.
.TP
.BI \-f makefile
Filename.
This allows you to specify an alternate makefile in which
.B gccmakedep
can place its output.
Specifying \(lq\-\(rq as the file name (that is,
.BR \-f\- )
sends the output to standard output instead of modifying an existing file.
.TP
.BI \-s string
Starting string delimiter.
This option permits you to specify a different string for
.B gccmakedep
to look for in the makefile.
The default is \(lq# DO NOT DELETE\(rq.
.TP
.BI \-\^\- " options " \-\^\-
If
.B gccmakedep
encounters a double hyphen (\-\^\-) in the argument list, then any
unrecognized arguments following it will be silently ignored.
A second double hyphen terminates this special treatment.
In this way,
.B gccmakedep
can be made to safely ignore esoteric compiler arguments that might
normally be found in a CFLAGS
.B make
macro (see the
.B EXAMPLE
section above).
.BR \-D ,
.BR \-I ,
and
.B \-U
options appearing between the pair of double hyphens are still processed
normally.
.SH "SEE ALSO"
.BR gcc (1),
.BR make (1),
.BR makedepend (1).
.SH AUTHOR
The version of the 
.B gccmakedep
included in this X.Org Foundation release was originally 
written by the XFree86 Project based on code supplied by Hongjiu Lu.
.PP
Colin Watson wrote this manual page, originally for the Debian Project,
based partly on the manual page for
.BR makedepend (1).
