/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoNullParameter;
import virtuoso.jdbc3.VirtuosoPreparedStatement;

public class VirtuosoCallableStatement
extends VirtuosoPreparedStatement
implements CallableStatement {
    private boolean _wasNull = false;
    private boolean _hasOut = false;
    protected int[] param_type = new int[this.parameters.capacity()];
    protected int[] param_scale = new int[this.parameters.capacity()];

    VirtuosoCallableStatement(VirtuosoConnection virtuosoConnection, String string) throws VirtuosoException {
        this(virtuosoConnection, string, 1003, 1007);
    }

    VirtuosoCallableStatement(VirtuosoConnection virtuosoConnection, String string, int n, int n2) throws VirtuosoException {
        super(virtuosoConnection, string, n, n2);
        for (int i = 0; i < this.param_type.length; ++i) {
            this.param_type[i] = 1111;
            this.param_scale[i] = 0;
        }
    }

    public void registerOutParameter(int n, int n2) throws VirtuosoException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, int n3) throws VirtuosoException {
        this._hasOut = true;
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.param_type[n - 1] = n2;
        this.param_scale[n - 1] = n3;
        switch (n2) {
            case 2002: 
            case 2003: {
                return;
            }
            case -5: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Long(Long.MAX_VALUE), n - 1);
                }
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                return;
            }
            case -7: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Boolean(false), n - 1);
                }
                return;
            }
            case 2004: 
            case 2005: {
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new String(), n - 1);
                }
                return;
            }
            case 91: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Date(0L), n - 1);
                }
                return;
            }
            case 92: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Time(0L), n - 1);
                }
                return;
            }
            case 93: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Timestamp(0L), n - 1);
                }
                return;
            }
            case 2: 
            case 3: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new BigDecimal(0.0).setScale(n3), n - 1);
                }
                return;
            }
            case 6: 
            case 8: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Double(Double.MAX_VALUE), n - 1);
                }
                return;
            }
            case 1111: 
            case 2000: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Object(), n - 1);
                }
                return;
            }
            case 0: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new VirtuosoNullParameter(n2, true), n - 1);
                }
                return;
            }
            case 7: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Float(Float.MAX_VALUE), n - 1);
                }
                return;
            }
            case 5: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Short(Short.MAX_VALUE), n - 1);
                }
                return;
            }
            case -6: 
            case 4: {
                if (this.objparams.elementAt(n - 1) == null) {
                    this.objparams.setElementAt(new Integer(Integer.MAX_VALUE), n - 1);
                }
                return;
            }
        }
    }

    public boolean wasNull() throws VirtuosoException {
        return this._wasNull;
    }

    public boolean hasOut() {
        return this._hasOut;
    }

    public String getString(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        return object.toString();
    }

    public boolean getBoolean(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        boolean bl = this._wasNull = object == null;
        if (this._wasNull) {
            return false;
        }
        Number number = (Number)object;
        return number.intValue() != 0;
    }

    public byte getByte(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)object).byteValue();
    }

    public short getShort(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)object).shortValue();
    }

    public int getInt(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)object).intValue();
    }

    public long getLong(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0L;
        }
        return ((Number)object).longValue();
    }

    public float getFloat(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0.0f;
        }
        return ((Number)object).floatValue();
    }

    public double getDouble(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return 0.0;
        }
        return ((Number)object).doubleValue();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws VirtuosoException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        return (byte[])object;
    }

    public Date getDate(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        return Date.valueOf(((Date)object).toString());
    }

    public Time getTime(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        if (object instanceof Time) {
            return Time.valueOf(((Time)object).toString());
        }
        if (object instanceof java.util.Date) {
            Time time = new Time(((java.util.Date)object).getTime());
            return Time.valueOf(time.toString());
        }
        if (object instanceof String) {
            return Time.valueOf((String)object);
        }
        return null;
    }

    public Timestamp getTimestamp(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        return Timestamp.valueOf(((Timestamp)object).toString());
    }

    public Object getObject(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        switch (this.param_type[n - 1]) {
            case -5: {
                object = new Long(((Number)object).longValue());
                break;
            }
            case 91: {
                object = Date.valueOf(object.toString());
                break;
            }
            case 92: {
                object = Time.valueOf(object.toString());
                break;
            }
            case 93: {
                object = Timestamp.valueOf(object.toString());
            }
        }
        return object;
    }

    public BigDecimal getBigDecimal(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object = this.mapJavaTypeToSqlType(this.objparams.elementAt(n - 1), this.param_type[n - 1], this.param_scale[n - 1]);
        this._wasNull = object == null;
        if (this._wasNull) {
            return null;
        }
        return (BigDecimal)object;
    }

    public Object getObject(int n, Map map) throws VirtuosoException {
        return this.getObject(n);
    }

    public Ref getRef(int n) throws VirtuosoException {
        throw new VirtuosoException("REF not supported", -7);
    }

    public Blob getBlob(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this._wasNull = this.objparams.elementAt(n - 1) == null;
        if (this._wasNull) {
            return null;
        }
        return (Blob)this.objparams.elementAt(n - 1);
    }

    public Clob getClob(int n) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this._wasNull = this.objparams.elementAt(n - 1) == null;
        if (this._wasNull) {
            return null;
        }
        return (Clob)this.objparams.elementAt(n - 1);
    }

    public Array getArray(int n) throws VirtuosoException {
        throw new VirtuosoException("ARRAY not supported", -7);
    }

    public Date getDate(int n, Calendar calendar) throws VirtuosoException {
        Date date = this.getDate(n);
        if (date == null) {
            return date;
        }
        calendar.setTime(date);
        return Date.valueOf(new Date(calendar.getTime().getTime()).toString());
    }

    public Time getTime(int n, Calendar calendar) throws VirtuosoException {
        Time time = this.getTime(n);
        if (time == null) {
            return time;
        }
        calendar.setTime(time);
        return Time.valueOf(new Time(calendar.getTime().getTime()).toString());
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (timestamp == null) {
            return timestamp;
        }
        calendar.setTime(timestamp);
        return Timestamp.valueOf(new Timestamp(calendar.getTime().getTime()).toString());
    }

    public void registerOutParameter(int n, int n2, String string) throws VirtuosoException {
        throw new VirtuosoException("UDTs not supported", -7);
    }

    public void registerOutParameter(String string, int n) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public URL getURL(int n) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }

    public void setNull(String string, int n) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setShort(String string, short s) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setInt(String string, int n) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setLong(String string, long l) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setString(String string, String string2) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public String getString(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public boolean getBoolean(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public byte getByte(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public short getShort(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public int getInt(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public long getLong(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public float getFloat(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public double getDouble(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public byte[] getBytes(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Date getDate(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Time getTime(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Object getObject(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Ref getRef(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Blob getBlob(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Clob getClob(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Array getArray(String string) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public URL getURL(String string) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }
}

