.\" Converted with mdoc2man 0.2
.\" from NiH: zip_source_file.mdoc,v 1.8 2005/07/15 14:11:16 wiz Exp 
.\" $NiH: zip_source_file.mdoc,v 1.8 2005/07/15 14:11:16 wiz Exp $
.\"
.\" zip_source_file.mdoc \-- create data source from a file
.\" Copyright (C) 2004, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SOURCE_FILE 3 "July 20, 2005" NiH
.SH "NAME"
zip_source_file \- create data source from a file
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
.PP
struct zip_source *
zip_source_file(struct zip *archive, const char *fname, off_t start, off_t len);
.SH "DESCRIPTION"
The function
zip_source_file
creates a zip source from a file.
zip_source_file
opens
\fBfname\fR
and reads
\fBlen\fR
bytes from offset
\fBstart\fR
from it.
If
\fBlen\fR
is 0 or \-1, the whole file (starting from
\fBstart )\fR
is used.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fBNULL\fR
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_source_file
fails if:
.RS
.TP 4
[ZIP_ER_INVAL]
\fBfname,\fR
\fBstart,\fR
or
\fBlen\fR
are invalid.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.TP 4
[ZIP_ER_OPEN]
Opening
\fBfname\fR
failed.
.RE
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source_buffer(3),
zip_source_filep(3),
zip_source_free(3),
zip_source_function(3),
zip_source_zip(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
