/***********************************************************************
*                                                                      *
*               This software is part of the ast package               *
*           Copyright (c) 1997-2007 AT&T Knowledge Ventures            *
*                      and is licensed under the                       *
*                  Common Public License, Version 1.0                  *
*                      by AT&T Knowledge Ventures                      *
*                                                                      *
*                A copy of the License is available at                 *
*            http://www.opensource.org/licenses/cpl1.0.txt             *
*         (with md5 checksum 059e8cd6165cb4c31e351f2b69388fd9)         *
*                                                                      *
*              Information and Software Systems Research               *
*                            AT&T Research                             *
*                           Florham Park NJ                            *
*                                                                      *
*                 Glenn Fowler <gsf@research.att.com>                  *
*                                                                      *
***********************************************************************/
#pragma prototyped
/*
 * Glenn Fowler
 * AT&T Research
 */

#include <ast.h>
#include <dlldefs.h>
#include <error.h>

/*
 * find and load library name with optional version ver and dlopen() flags
 * at least one dlopen() is called to initialize dlerror()
 * if path!=0 then library path up to size chars copied to path with trailing 0
 * if name contains a directory prefix then library search is limited to the dir and siblings
 */

extern void*
dllfind(const char* lib, const char* ver, int flags, char* path, size_t size)
{
	char*	id;
	void*	dll;

	if ((id = error_info.id) && (dll = dllplug(id, lib, ver, flags, path, size)))
		return dll;
	return dllplug(NiL, lib, ver, flags, path, size);
}
