/* The GIMP -- an image manipulation program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "pdb-types.h"
#include "procedural_db.h"

#include "core/gimp.h"

static ProcRecord fonts_popup_proc;
static ProcRecord fonts_close_popup_proc;
static ProcRecord fonts_set_popup_proc;

void
register_font_select_procs (Gimp *gimp)
{
  procedural_db_register (gimp, &fonts_popup_proc);
  procedural_db_register (gimp, &fonts_close_popup_proc);
  procedural_db_register (gimp, &fonts_set_popup_proc);
}

static Argument *
fonts_popup_invoker (Gimp         *gimp,
                     GimpContext  *context,
                     GimpProgress *progress,
                     Argument     *args)
{
  gboolean success = TRUE;
  gchar *font_callback;
  gchar *popup_title;
  gchar *initial_font;

  font_callback = (gchar *) args[0].value.pdb_pointer;
  if (font_callback == NULL || !g_utf8_validate (font_callback, -1, NULL))
    success = FALSE;

  popup_title = (gchar *) args[1].value.pdb_pointer;
  if (popup_title == NULL || !g_utf8_validate (popup_title, -1, NULL))
    success = FALSE;

  initial_font = (gchar *) args[2].value.pdb_pointer;
  if (initial_font && !g_utf8_validate (initial_font, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (gimp->no_interface ||
          ! procedural_db_lookup (gimp, font_callback) ||
          ! gimp_pdb_dialog_new (gimp, context, gimp->fonts,
                                 popup_title, font_callback, initial_font,
                                 NULL))
        success = FALSE;
    }

  return procedural_db_return_args (&fonts_popup_proc, success);
}

static ProcArg fonts_popup_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "font_callback",
    "The callback PDB proc to call when font selection is made"
  },
  {
    GIMP_PDB_STRING,
    "popup_title",
    "Title to give the font popup window"
  },
  {
    GIMP_PDB_STRING,
    "initial_font",
    "The name of the font to set as the first selected"
  }
};

static ProcRecord fonts_popup_proc =
{
  "gimp_fonts_popup",
  "Invokes the Gimp font selection.",
  "This procedure popups the font selection dialog.",
  "Sven Neumann <sven@gimp.org>",
  "Sven Neumann",
  "2003",
  NULL,
  GIMP_INTERNAL,
  3,
  fonts_popup_inargs,
  0,
  NULL,
  { { fonts_popup_invoker } }
};

static Argument *
fonts_close_popup_invoker (Gimp         *gimp,
                           GimpContext  *context,
                           GimpProgress *progress,
                           Argument     *args)
{
  gboolean success = TRUE;
  gchar *font_callback;

  font_callback = (gchar *) args[0].value.pdb_pointer;
  if (font_callback == NULL || !g_utf8_validate (font_callback, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (gimp->no_interface ||
          ! procedural_db_lookup (gimp, font_callback) ||
          ! gimp_pdb_dialog_close (gimp, gimp->fonts, font_callback))
        success = FALSE;
    }

  return procedural_db_return_args (&fonts_close_popup_proc, success);
}

static ProcArg fonts_close_popup_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "font_callback",
    "The name of the callback registered for this popup"
  }
};

static ProcRecord fonts_close_popup_proc =
{
  "gimp_fonts_close_popup",
  "Popdown the Gimp font selection.",
  "This procedure closes an opened font selection dialog.",
  "Sven Neumann <sven@gimp.org>",
  "Sven Neumann",
  "2003",
  NULL,
  GIMP_INTERNAL,
  1,
  fonts_close_popup_inargs,
  0,
  NULL,
  { { fonts_close_popup_invoker } }
};

static Argument *
fonts_set_popup_invoker (Gimp         *gimp,
                         GimpContext  *context,
                         GimpProgress *progress,
                         Argument     *args)
{
  gboolean success = TRUE;
  gchar *font_callback;
  gchar *font_name;

  font_callback = (gchar *) args[0].value.pdb_pointer;
  if (font_callback == NULL || !g_utf8_validate (font_callback, -1, NULL))
    success = FALSE;

  font_name = (gchar *) args[1].value.pdb_pointer;
  if (font_name == NULL || !g_utf8_validate (font_name, -1, NULL))
    success = FALSE;

  if (success)
    {
      if (gimp->no_interface ||
          ! procedural_db_lookup (gimp, font_callback) ||
          ! gimp_pdb_dialog_set (gimp, gimp->fonts, font_callback, font_name,
                                 NULL))
        success = FALSE;
    }

  return procedural_db_return_args (&fonts_set_popup_proc, success);
}

static ProcArg fonts_set_popup_inargs[] =
{
  {
    GIMP_PDB_STRING,
    "font_callback",
    "The name of the callback registered for this popup"
  },
  {
    GIMP_PDB_STRING,
    "font_name",
    "The name of the font to set as selected"
  }
};

static ProcRecord fonts_set_popup_proc =
{
  "gimp_fonts_set_popup",
  "Sets the current font selection in a popup.",
  "Sets the current font selection in a popup.",
  "Sven Neumann <sven@gimp.org>",
  "Sven Neumann",
  "2003",
  NULL,
  GIMP_INTERNAL,
  2,
  fonts_set_popup_inargs,
  0,
  NULL,
  { { fonts_set_popup_invoker } }
};
