/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc;

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        super.finish();
        this.put4((int)this.crc.getValue());
        this.put4(this.def.getTotalIn());
    }

    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, 512);
    }

    public GZIPOutputStream(OutputStream out, int readsize) throws IOException {
        super(out, new Deflater(-1, true), readsize);
        this.put2(35615);
        out.write(8);
        out.write(0);
        this.put2(0);
        this.put2(0);
        out.write(0);
        out.write(255);
        this.crc = new CRC32();
    }

    public synchronized void write(int bval) throws IOException {
        super.write(bval);
        this.crc.update(bval);
    }

    public synchronized void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public synchronized void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        this.crc.update(buf, off, len);
    }

    private final void put2(int i) throws IOException {
        this.out.write(i);
        this.out.write(i >> 8);
    }

    private final void put4(int i) throws IOException {
        this.out.write(i);
        this.out.write(i >> 8);
        this.out.write(i >> 16);
        this.out.write(i >> 24);
    }
}

