/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

public abstract class QuadCurve2D
implements Shape,
Cloneable {
    protected QuadCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX();

    public abstract double getCtrlY();

    public abstract Point2D getCtrlPt();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setCurve(double[] coords, int offset) {
        this.setCurve(coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++], coords[offset++]);
    }

    public void setCurve(Point2D p1, Point2D c, Point2D p2) {
        this.setCurve(p1.getX(), p1.getY(), c.getX(), c.getY(), p2.getX(), p2.getY());
    }

    public void setCurve(Point2D[] pts, int offset) {
        this.setCurve(pts[offset].getX(), pts[offset].getY(), pts[offset + 1].getX(), pts[offset + 1].getY(), pts[offset + 2].getX(), pts[offset + 2].getY());
    }

    public void setCurve(QuadCurve2D c) {
        this.setCurve(c.getX1(), c.getY1(), c.getCtrlX(), c.getCtrlY(), c.getX2(), c.getY2());
    }

    public static double getFlatnessSq(double x1, double y1, double cx, double cy, double x2, double y2) {
        return Line2D.ptSegDistSq(x1, y1, x2, y2, cx, cy);
    }

    public static double getFlatness(double x1, double y1, double cx, double cy, double x2, double y2) {
        return Line2D.ptSegDist(x1, y1, x2, y2, cx, cy);
    }

    public static double getFlatnessSq(double[] coords, int offset) {
        return Line2D.ptSegDistSq(coords[offset], coords[offset + 1], coords[offset + 4], coords[offset + 5], coords[offset + 2], coords[offset + 3]);
    }

    public static double getFlatness(double[] coords, int offset) {
        return Line2D.ptSegDist(coords[offset], coords[offset + 1], coords[offset + 4], coords[offset + 5], coords[offset + 2], coords[offset + 3]);
    }

    public double getFlatnessSq() {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public double getFlatness() {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public void subdivide(QuadCurve2D left, QuadCurve2D right) {
        double[] d = new double[]{this.getX1(), this.getY1(), this.getCtrlX(), this.getCtrlY(), this.getX2(), this.getY2(), 0.0, 0.0, 0.0, 0.0};
        QuadCurve2D.subdivide(d, 0, d, 0, d, 4);
        if (left != null) {
            left.setCurve(d, 0);
        }
        if (right != null) {
            right.setCurve(d, 4);
        }
    }

    public static void subdivide(QuadCurve2D src, QuadCurve2D left, QuadCurve2D right) {
        src.subdivide(left, right);
    }

    public static void subdivide(double[] src, int srcOff, double[] left, int leftOff, double[] right, int rightOff) {
        double x1 = src[srcOff];
        double y1 = src[srcOff + 1];
        double xc = src[srcOff + 2];
        double yc = src[srcOff + 3];
        double x2 = src[srcOff + 4];
        double y2 = src[srcOff + 5];
        if (left != null) {
            left[leftOff] = x1;
            left[leftOff + 1] = y1;
        }
        if (right != null) {
            right[rightOff + 4] = x2;
            right[rightOff + 5] = y2;
        }
        x1 = (x1 + xc) / 2.0;
        x2 = (xc + x2) / 2.0;
        xc = (x1 + x2) / 2.0;
        y1 = (y1 + yc) / 2.0;
        y2 = (y2 + yc) / 2.0;
        yc = (y1 + y2) / 2.0;
        if (left != null) {
            left[leftOff + 2] = x1;
            left[leftOff + 3] = y1;
            left[leftOff + 4] = xc;
            left[leftOff + 5] = yc;
        }
        if (right != null) {
            right[rightOff] = xc;
            right[rightOff + 1] = yc;
            right[rightOff + 2] = x2;
            right[rightOff + 3] = y2;
        }
    }

    public static int solveQuadratic(double[] eqn) {
        return QuadCurve2D.solveQuadratic(eqn, eqn);
    }

    public static int solveQuadratic(double[] eqn, double[] res) {
        double c = eqn[0];
        double b = eqn[1];
        double a = eqn[2];
        if (a == 0.0) {
            if (b == 0.0) {
                return -1;
            }
            res[0] = -c / b;
            return 1;
        }
        double d = b;
        double disc = d * d - 4.0 * a * c;
        if (disc < 0.0) {
            return 0;
        }
        if (disc == 0.0) {
            res[0] = -0.5 * b / a;
            return 1;
        }
        if (b == 0.0) {
            double r = Math.abs(0.5 * Math.sqrt(disc) / a);
            res[0] = -r;
            res[1] = r;
        } else {
            double sgnb = b > 0.0 ? 1.0 : -1.0;
            double temp = -0.5 * (b + sgnb * Math.sqrt(disc));
            res[0] = temp / a;
            res[1] = c / temp;
        }
        return 2;
    }

    public boolean contains(double x, double y) {
        throw new Error("not implemented");
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        throw new Error("not implemented");
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        throw new Error("not implemented");
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PathIterator(this, at){
            private /* synthetic */ QuadCurve2D this$0;
            private /* synthetic */ AffineTransform val$at;
            private int current;
            {
                this.this$0 = this$0;
                this.finit$(parm$at);
            }

            private /* synthetic */ void finit$(AffineTransform parm$at) {
                this.val$at = parm$at;
                this.current = 0;
            }

            public int getWindingRule() {
                return 1;
            }

            public boolean isDone() {
                return this.current > 1;
            }

            public void next() {
                ++this.current;
            }

            public int currentSegment(float[] coords) {
                int result;
                switch (this.current) {
                    case 0: {
                        coords[0] = (float)this.this$0.getX1();
                        coords[1] = (float)this.this$0.getY1();
                        result = 0;
                        break;
                    }
                    case 1: {
                        coords[0] = (float)this.this$0.getCtrlX();
                        coords[1] = (float)this.this$0.getCtrlY();
                        coords[2] = (float)this.this$0.getX2();
                        coords[3] = (float)this.this$0.getY2();
                        result = 2;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("quad iterator out of bounds");
                    }
                }
                if (this.val$at != null) {
                    this.val$at.transform(coords, 0, coords, 0, 2);
                }
                return result;
            }

            public int currentSegment(double[] coords) {
                int result;
                switch (this.current) {
                    case 0: {
                        coords[0] = this.this$0.getX1();
                        coords[1] = this.this$0.getY1();
                        result = 0;
                        break;
                    }
                    case 1: {
                        coords[0] = this.this$0.getCtrlX();
                        coords[1] = this.this$0.getCtrlY();
                        coords[2] = this.this$0.getX2();
                        coords[3] = this.this$0.getY2();
                        result = 2;
                        break;
                    }
                    default: {
                        throw new NoSuchElementException("quad iterator out of bounds");
                    }
                }
                if (this.val$at != null) {
                    this.val$at.transform(coords, 0, coords, 0, 2);
                }
                return result;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public static class Float
    extends QuadCurve2D {
        public float x1;
        public float y1;
        public float ctrlx;
        public float ctrly;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float x1, float y1, float cx, float cy, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx = cx;
            this.ctrly = cy;
            this.x2 = x2;
            this.y2 = y2;
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getCtrlX() {
            return this.ctrlx;
        }

        public double getCtrlY() {
            return this.ctrly;
        }

        public Point2D getCtrlPt() {
            return new Point2D.Float(this.ctrlx, this.ctrly);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double cx, double cy, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.ctrlx = (float)cx;
            this.ctrly = (float)cy;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setCurve(float x1, float y1, float cx, float cy, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx = cx;
            this.ctrly = cy;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            float nx1 = Math.min(Math.min(this.x1, this.ctrlx), this.x2);
            float ny1 = Math.min(Math.min(this.y1, this.ctrly), this.y2);
            float nx2 = Math.max(Math.max(this.x1, this.ctrlx), this.x2);
            float ny2 = Math.max(Math.max(this.y1, this.ctrly), this.y2);
            return new Rectangle2D.Float(nx1, ny1, nx2 - nx1, ny2 - ny1);
        }
    }

    public static class Double
    extends QuadCurve2D {
        public double x1;
        public double y1;
        public double ctrlx;
        public double ctrly;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double x1, double y1, double cx, double cy, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx = cx;
            this.ctrly = cy;
            this.x2 = x2;
            this.y2 = y2;
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getCtrlX() {
            return this.ctrlx;
        }

        public double getCtrlY() {
            return this.ctrly;
        }

        public Point2D getCtrlPt() {
            return new Point2D.Double(this.ctrlx, this.ctrly);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setCurve(double x1, double y1, double cx, double cy, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.ctrlx = cx;
            this.ctrly = cy;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Rectangle2D getBounds2D() {
            double nx1 = Math.min(Math.min(this.x1, this.ctrlx), this.x2);
            double ny1 = Math.min(Math.min(this.y1, this.ctrly), this.y2);
            double nx2 = Math.max(Math.max(this.x1, this.ctrlx), this.x2);
            double ny2 = Math.max(Math.max(this.y1, this.ctrly), this.y2);
            return new Rectangle2D.Double(nx1, ny1, nx2 - nx1, ny2 - ny1);
        }
    }
}

