Name: docbook-style-xsl
Version: 1.49
Release: 1
Group: Applications/Text

Summary: Norman Walsh's XSL stylesheets for DocBook XML.

License: Distributable
URL: http://docbook.sourceforge.net/projects/xsl/

Provides: docbook-xsl = %{version}
PreReq: docbook-dtd-xml
# xml-common was using /usr/share/xml until 0.6.3-8.
PreReq: xml-common >= 0.6.3-8
# PassiveTeX before 1.11 can't handle the new master-* stuff.
Conflicts: passivetex < 1.11

BuildRoot: %{_tmppath}/%{name}-%{version}

BuildArch: noarch
Source0: http://prdownloads.sourceforge.net/docbook/docbook-xsl-%{version}.tar.gz
Source1: %{name}-%{version}.Makefile


%description
These XSL stylesheets allow you to transform any DocBook XML document to
other formats, such as HTML, FO, and XHMTL.  They are highly customizable.


%prep
%setup -q -n docbook-xsl-%{version}
cp %{SOURCE1} Makefile


%build


%install
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR
make install BINDIR=$DESTDIR/usr/bin DESTDIR=$DESTDIR/usr/share/sgml/docbook/xsl-stylesheets-%{version}-%{release}
ln -s xsl-stylesheets-%{version}-%{release} \
	$DESTDIR/usr/share/sgml/docbook/xsl-stylesheets


%clean
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR


%files
%defattr (-,root,root)
%doc BUGS
%doc ChangeLog
%doc README
%doc TODO
%doc WhatsNew
%doc doc
%doc docsrc
/usr/share/sgml/docbook/xsl-stylesheets-%{version}-%{release}
/usr/share/sgml/docbook/xsl-stylesheets


%post
CATALOG=/etc/xml/catalog
/usr/bin/xmlcatalog --noout --add "rewriteSystem" \
 "http://docbook.sourceforge.net/release/xsl/%{version}" \
 "file:///usr/share/sgml/docbook/xsl-stylesheets-%{version}-%{release}" $CATALOG
/usr/bin/xmlcatalog --noout --add "rewriteURI" \
 "http://docbook.sourceforge.net/release/xsl/%{version}" \
 "file:///usr/share/sgml/docbook/xsl-stylesheets-%{version}-%{release}" $CATALOG
/usr/bin/xmlcatalog --noout --add "rewriteSystem" \
 "http://docbook.sourceforge.net/release/xsl/current" \
 "file:///usr/share/sgml/docbook/xsl-stylesheets-%{version}-%{release}" $CATALOG
/usr/bin/xmlcatalog --noout --add "rewriteURI" \
 "http://docbook.sourceforge.net/release/xsl/current" \
 "file:///usr/share/sgml/docbook/xsl-stylesheets-%{version}-%{release}" $CATALOG


%postun
CATALOG=/etc/xml/catalog
/usr/bin/xmlcatalog --noout --del \
 "file:///usr/share/sgml/docbook/xsl-stylesheets-%{version}-%{release}" $CATALOG


%changelog
* Thu Feb 21 2002 Tim Waugh <twaugh@redhat.com> 1.49-1
- 1.49.
- Rebuild in new environment.

* Fri Feb  1 2002 Tim Waugh <twaugh@redhat.com> 1.48-4
- Put URIs instead of pathnames in the XML catalog.

* Thu Jan 17 2002 Tim Waugh <twaugh@redhat.com> 1.48-3
- Back to /usr/share/sgml.

* Wed Jan 09 2002 Tim Powers <timp@redhat.com> 1.48-2
- automated rebuild

* Mon Jan  7 2002 Tim Waugh <twaugh@redhat.com> 1.48-1
- 1.48.

* Sat Dec  8 2001 Tim Waugh <twaugh@redhat.com> 1.47-2
- Conflict with PassiveTeX before 1.11.

* Tue Oct 16 2001 Tim Waugh <twaugh@redhat.com> 1.47-1
- 1.47-experimental.

* Tue Oct  9 2001 Tim Waugh <twaugh@redhat.com> 1.45-2
- Fix unversioned symlink.

* Mon Oct  8 2001 Tim Waugh <twaugh@redhat.com> 1.45-1
- XML Catalog entries.
- Move files to /usr/share/xml.

* Mon Oct  1 2001 Tim Waugh <twaugh@redhat.com> 1.45-0.1
- 1.45.
- Built for Red Hat Linux.

* Tue Jun 26 2001 Chris Runge <crunge@pobox.com>
- 1.40

* Fri Jun 09 2001 Chris Runge <crunge@pobox.com>
- added extensions and additional doc
- bin added to doc; the Perl files are for Win32 Perl and so need some
  conversion first

* Fri Jun 08 2001 Chris Runge <crunge@pobox.com>
- Initial RPM (based on docbook-style-dsssl RPM)
- note: no catalog right now (I don't know how to do it; and not sure why
  it is necessary)
