#ifndef __KVIEWPART_H
#define __KVIEWPART_H


#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <kdirwatch.h>
#include <qtimer.h>

class KAboutDialog;
class KAccel;
class KAction;
class KSelectAction;
class KTempFile;
class KToggleAction;
class KViewPartExtension;
class KInstance;
class KURL;
class QSize;
class QHBoxLayout;
class pageSizeDialog;

#include "kviewpart_iface.h"
#include "kmultipage.h"
#include "pageSize.h"
#include "zoom.h"
#include "zoomlimits.h"

class KViewPart : public KViewPart_Iface
{
  Q_OBJECT

public:
  KViewPart(QWidget *parentWidget, const char *widgetName, QObject *parent,
            const char *name, const QStringList& args);
  virtual ~KViewPart();

  static KAboutData* createAboutData();

  bool isValid() { return multiPage; }

  // Returns a description of the current page size, for use in the
  // statusbar of the kviewshell that embeds this KViewPart.
  QString pageSizeDescription(void);

signals:
  void zoomChanged(const QString &);
  void pageChanged(const QString &);
  void sizeChanged(const QString &);
  void scrollbarStatusChanged(bool);
  void fileOpened();

public slots:
  void slotSetFullPage(bool fullpage);

  virtual void slotFileOpen();
  virtual bool closeURL();
  virtual QStringList fileFormats();
  void setStatusBarTextFromMultiPage(const QString &);
  /** Calling this slot will cause the kmultipage to reload the file */
  void reload(void);

  void restoreDocument(const KURL &url, int page);
  void saveDocumentRestoreInfo(KConfig* config);

protected slots:
  void slotShowSidebar();
  void slotMedia (int);

  void goToPage();

  void zoomIn();
  void zoomOut();

  void disableZoomFit();
  void updateZoomLevel();

  void enableFitToPage(bool);
  void enableFitToHeight(bool);
  void enableFitToWidth(bool);

  void fitToPage();
  void fitToHeight();
  void fitToWidth();

  void slotPrint();

  void fileChanged(const QString&);

  // Connected to the QLineEdit in the toolbar.
  void setZoomValue(const QString &);


protected:
  KToggleAction *showSidebar, *scrollbarHandling;
  KSelectAction *orientation, *media, *zoom_action;

  virtual bool openFile();

  void connectNotify ( const char * );

  void partActivateEvent( KParts::PartActivateEvent *ev );
  void guiActivateEvent( KParts::GUIActivateEvent *ev );

private slots:
  void pageInfo(int numpages, int currentpage);
  void checkActions();

  /** This is the slot where mouseWheel events are processed that come
      from the multipage/scrollview. This method calles scroll, a
      delta-value of 120 (i.e. one notch on a standard wheel mouse)
      scrolls by two 'lines'. */
  void wheelEvent(QWheelEvent *);

  void slotStartFitTimer();

  void doSettings();
  void preferencesChanged();

  void aboutKViewShell();

  // Relay signals to the multipage. We cannot connect to the
  // slots of the multipage directly because than we would have
  // to recreate the whole interface whenever a new multipage is loaded.
  void mp_prevPage();
  void mp_nextPage();
  void mp_firstPage();
  void mp_lastPage();

  void mp_readUp();
  void mp_readDown();

  void mp_scrollUp();
  void mp_scrollDown();
  void mp_scrollLeft();
  void mp_scrollRight();
  void mp_scrollUpPage();
  void mp_scrollDownPage();
  void mp_scrollLeftPage();
  void mp_scrollRightPage();

  void mp_slotSave();
  void mp_slotSave_defaultFilename();

  void mp_doGoBack();
  void mp_doGoForward();

private:
  void initializeMultiPage();

  // This method reads the configuration file. It should only be
  // called when no document is loaded.
  void readSettings();
  void writeSettings();

  // The method openFile of this kviewpart can be called even if
  // m_file points to a compressed file. In that case, the temporary
  // file tmpUnzipped will be created and a decompressed copy of the
  // file stored there.
  KTempFile *tmpUnzipped;

  KDirWatch *watch;
  KAccel *accel;
  KAction *zoomInAct, *zoomOutAct, *backAct, *forwardAct,
    *startAct, *endAct, *endDocAct, *markAct, *gotoAct,
    *saveAction, *saveAsAction, *printAction, *readUpAct, *readDownAct;
  KAction *backAction;
  KAction *forwardAction;
  KAction *settingsAction;
  KAction* aboutAction;
  KToggleAction *watchAct,*useDocumentSpecifiedSize,
    *fitPageAct, *fitHeightAct, *fitWidthAct;
  KSelectAction* viewModeAction;

  KMultiPage *multiPage;
  // Name of the library of the currently loaded multiPage.
  // Is used to check if it is really necessary to load a new MultiPage.
  QString multiPageLibrary;

  KViewPartExtension *m_extension;

  bool pageChangeIsConnected;

  QWidget *mainWidget;
  QHBoxLayout* mainLayout;

  /** This entry stores the paper size that the user has requested in
      the preferences dialog. If that paper size is actually used or
      not, depends on if the document specifies a paper size of its
      own and if the user has chosen the option "use document
      specified paper size if available" */
  pageSize  userRequestedPaperSize;

  /** stores the current zoom value */
  class zoom      _zoomVal;
  pageSizeDialog *_pageSizeDialog;

  QTimer fitTimer;

  KAboutDialog* aboutDialog;
};


class KViewPartExtension : public KParts::BrowserExtension
{
  Q_OBJECT
  friend class KViewPart;

public:

  KViewPartExtension(KViewPart *parent);
  virtual ~KViewPartExtension() {}

};


#endif
