.TH sane-plustek_pp 5 "18 June 2004" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-plustek_pp
.SH NAME
sane-plustek_pp \- SANE backend for Plustek parallel port
flatbed scanners
.SH DESCRIPTION
The
.B sane-plustek_pp
library implements a SANE (Scanner Access Now Easy) backend that
provides access to Plustek ASIC 9600[1/3] and P9800[1/3] based
parallel port flatbed scanners.
The access of the scanner is either done directly by the backend
or via kernel module, called pt_drv which can be created out of
the plustek_pp backend code - see also section
.B "BUILDING THE KERNEL MODULE"
for further information. 

.SH "SUPPORTED DEVICES"

At present, the following scanners should work with this backend
and/or the kernel module:
.PP
.B "PLUSTEK SCANNERS"
.PP
Parallelport Model:    ASIC: Properties:
.br
---------------------- ----- ------------------------
.br
OpticPro PT12          98003 600x1200 dpi 36bit 512Kb
.br
OpticPro P12           98003 600x1200 dpi 36bit 512Kb
.br
OpticPro 9636T/12000T  98001 600x1200 dpi 36bit 512Kb
.br
OpticPro 12000P Turbo  98001 600x1200 dpi 36bit 512Kb
.br
OpticPro 9636P+/Turbo  98001 600x1200 dpi 36bit 512Kb
.br
OpticPro 9636P         96003 600x1200 dpi 36bit 128Kb
.br
OpticPro 12000P/96000P 96003 600x1200 dpi 36bit 128Kb
.br
OpticPro 1236P         96003 600x1200 dpi 30bit 128Kb
.br
OpticPro 9600P         96003 600x1200 dpi 30bit 128Kb
.br
OpticPro 9630P/FBIV    96003 600x1200 dpi 30bit 128Kb
.br
OpticPro 9630PL (14")  96003 600x1200 dpi 30bit 128Kb
.br
OpticPro A3I           96003  400x800 dpi 36bit 128Kb
.br
OpticPro 600P/6000P    96003  300x600 dpi 30bit  32Kb
.br
OpticPro 4831P         96003  300x600 dpi 30bit  32Kb
.br
OpticPro 4830P/FBIII   96003  300x600 dpi 30bit  32Kb
.br
OpticPro 4800P/FBII    96001  300x600 dpi 24bit  32Kb
.br
.PP

.B "PRIMAX SCANNERS"

There are some scanners sold by Primax, but they are in fact
Plustek devices. These scanners are also supported.
The following table will show the relationship:
.PP
Model:                      Plustek Model:  Remarks:
.br
--------------------------- --------------  ------------
.br
Colorado 4800               OpticPro 4800   not tested
.br
Compact 4800 Direct         OpticPro 600    mov=2
.br
Compact 4800 Direct 30bit   OpticPro 4830   mov=7
.br
Compact 9600 Direct 30bit   OpticPro 9630   works
.PP

.B "GENIUS SCANNERS"

The following devices are sold as Genius Scanners, but are in fact
Plustek devices.
The table will show the relationship:
.PP
Model:                      Remarks:
.br
--------------------------- ----------------------------
.br
Colorpage Vivid III V2      Like P12 but has two buttons
.br
                            and Wolfson DAC
.PP

.B "ARIES SCANNERS"

There's one scanner sold as Aries Scanner, but is in fact a
Plustek device.
The following table will show the relationship:
.PP
Model:                      Plustek Model:  Remarks:
.br
--------------------------- --------------  ------------
.br
Scan-It 4800                OpticPro 600    mov=2
.PP

.B "BrightScan SCANNERS"

There's one scanner sold as BrightScan OpticPro Scanner, this is also
a rebadged Plustek device.
The following table will show the relationship:
.PP
Model:                      Remarks:
.br
--------------------------- ----------------------------
.br
BrightScan OpticPro         OpticPro P12

.SH "DEVICE NAMES"
This backend works in two modes, the so called "direct-mode"
and the "kernel-mode". In direct-mode, the user-space backend is
used, in kernel-mode, you should have a kernel-module named pt_drv
loaded.
This backends default device is:
.PP
.RS
.I 0x378
.RE
.PP
This "default device" will be used, if no configuration
file can be found. It is rather the base address of the parallel port
on i386 machines.
.PP
As the backend supports up to four devices, it is possible to
specify them in the configuration file
.PP
.RS
.I @CONFIGDIR@/plustek_pp.conf
.RE
.PP
See this file for examples.
.PP

.SH "CONFIGURATION"
.PP
This section decribes the backends' configuration file entries.
The file is located at:
.PP
.RS
.I @CONFIGDIR@/plustek_pp.conf
.RE
.PP
For a proper setup, you will need at least two entries:

.TP
.I [direct]
.TP
.I device 0x378
.PP
or
.TP
.I [kernel]
.TP
.I device /dev/pt_drv
.PP
.I direct
tells the backend, that the following devicename (here
.I 0x378
) has to be interpreted as parallel port scanner device. In
fact it is the address to use, alternatively you can use
.I /dev/parport0
if the backend has been compiled with libieee1284 support.
.I kernel
should only be used, when a kernel-module has been built
out of the backend sources. See below for more instructions
about this.
.PP
Further options:
.PP
option warmup t
.RS
.I t
specifies the warmup period in seconds
.RE
.PP
option lampOff t
.RS
.I t
is the time in seconds for switching off the lamps in
standby mode
.RE
.PP
option lOffonEnd b
.RS
.I b
specifies the behaviour when closing the backend, 1 --> switch
lamps off, 0 --> do not change lamp status
.RE
.PP
option mov m
.RS
.I m
is the model override switch, which only works in direct mode.
.I m
=0 - default: no override
.br
.I m
=1 - OpticPro 9630PL override (works if OP9630
.br
       has been detected) forces legal size (14")
.br
.I m
=2 - Primax 4800Direct override (works if OP600
.br
       has been detected) swaps red/green color
.br
.I m
=3 - OpticPro 9636 override (works if OP9636 has
.br
       been detected) disables backends
.br
       transparency/negativ capabilities
.br
.I m
=4 - OpticPro 9636P override (works if OP9636 has
.br
       been detected) disables backends
.br
       transparency/negativ capabilities
.br
.I m
=5 - OpticPro A3I override (works if OP12000 has
.br
       been detected) enables A3 scanning
.br
.I m
=6 - OpticPro 4800P override (works if OP600
.br
       has been detected) swaps red/green color
.br
.I m
=7 - Primax 4800Direct 30bit override (works if
.br
       OP4830 has been detected)
.RE
.PP
See the plustek_pp.conf file for examples.
.PP

.SH "BUILDING THE KERNEL MODULE"
As mentioned before, the plustek_pp backend code can also
be compiled and installed as linux kernel module. To do so,
you will need the source-files of this sane-backend installation.
Unpack this tar-ball and go to the directory:
.br
.I sane-backends/doc/plustek
.br
Within this directory, you should find a script called:
.br
.I MakeModule.sh
.br
Now if your Linux kernelsources are installed correctly, 
it should be possible to build, install and load the 
module
.B pt_drv.
.B Please note, 
that the kernelsources need to be configured correctly.
Refer to your distributions 
manual on how this is done. As root user, try
.br
.I ./MakeModule.sh
.br
the script will try and get all necessary information about your
running kernel and will lead you through the whole installation
process.
.br
.B Note: Installing and loading the can only be done as 
superuser.
.PP

.SH "KERNEL MODULE SETUP"
The configuration of the kernel module is done by providing
some or more options found below to the kernel module at
load time. This can be done by invoking insmod with the
appropriate parameters or appending the options to the file
.B /etc/modules.conf (kernel < 2.6.x)
or
.B /etc/modprobe.conf (kernel >= 2.6.x)
.PP
.B
The Options:
.br
lampoff=lll
.RS
The value
.I lll
tells the driver, after how many seconds to
switch-off the lamp(s). The default value is 180.
0 will disable this feature.
.br
.B HINT:
Do not use a value that is too small, because often
switching on/off the lamps will reduce their lifetime.
.RE
.PP
port=ppp
.RS
.I ppp
specifies the port base address, where the scanner
is connected to. The default value is 0x378 which
normaly is standard.
.RE
.PP
warmup=www
.RS
.I www
specifies the time in seconds, how long a lamp has to be on,
until the driver will start to scan. The default value is 30.
.RE
.PP
lOffonEnd=e
.RS
.I e
specifies the behaviour when unloading the driver, 1 --> switch
lamps off, 0 --> do not change lamp status
.RE
.PP
slowIO=s
.RS
.I s
specifies which I/O functions the driver should use, 1 --> use
delayed functions, 0 --> use the non-delayed ones
.RE
.PP
forceMode=fm
.RS
.I fm
specifies port mode which should be used, 0 --> autodetection,
1 --> use SPP mode and 2 --> use EPP mode
.RE
.PP
mov=m
.RS
.I m
=0 - default: no override
.br
.I m
=1 - OpticPro 9630PL override (works if OP9630
.br
       has been detected) forces legal size (14")
.br
.I m
=2 - Primax 4800Direct override (works if OP600
.br
       has been detected) swaps red/green color
.br
.I m
=3 - OpticPro 9636 override (works if OP9636 has
.br
       been detected) disables backends
.br
       transparency/negativ capabilities
.br
.I m
=4 - OpticPro 9636P override (works if OP9636 has
.br
       been detected) disables backends
.br
       transparency/negativ capabilities
.br
.I m
=5 - OpticPro A3I override (works if OP12000 has
.br
       been detected) enables A3 scanning
.br
.I m
=6 - OpticPro 4800P override (works if OP600
.br
       has been detected) swaps red/green color
.br
.I m
=7 - Primax 4800Direct 30bit override (works if
.br
       OP4830 has been detected)
.RE
.PP
Sample entry for file
.B "/etc/modules.conf"
:
.br
.I alias char-major-40 pt_drv
.br
.I pre-install pt_drv modprobe -k parport
.br
.I options pt_drv lampoff=180 warmup=15 port=0x378 lOffonEnd=0 mov=0 slowIO=0 forceMode=0
.PP
For multidevice support, simply add values separated by commas to
the different options
.br
.I options pt_drv port=0x378,0x278 mov=0,4 slowIO=0,1 forceMode=0,1
.PP
Remember to call depmod after changing /etc/conf.modules.
.PP

.SH "PARALLEL PORT MODES"
.TP
The current driver works best, when the parallel port
has been set to EPP-mode. When detecting any other
mode such as ECP or PS/2 the driver tries to set to a
faster, supported mode. If this fails, it will use the
SPP mode, as this mode should work with all Linux supported
parallel ports. If in doubt, enter your BIOS and set it to
any mode except ECP.
.PP
Former Plustek scanner models (4830, 9630) supplied a
ISA parallel port adapter card. This card is
.BR not
supported by the driver.
.PP
The ASIC 96001/3 based models have sometimes trouble with
high resolution modes. If you encounter sporadic corrupted
images (parts duplicated or shifted horizontally) kill all
other applications before scanning and (if sufficient
memory available) disable swapping.
.PP
See the plustek_pp.conf file for examples.
.PP

.SH FILES
.TP
.I @CONFIGDIR@/plustek_pp.conf
The backend configuration file
.TP
.I @LIBDIR@/libsane-plustek_pp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-plustek_pp.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.TP
.I /lib/modules/<Kernel-Version>/kernel/drivers/parport/pt_drv.o
The Linux kernelmodule for kernels < 2.6.x.
.TP
.I /lib/modules/<Kernel-Version>/kernel/drivers/parport/pt_drv.ko
The Linux kernelmodule for kernels >= 2.6.x.
.PP

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_PLUSTEK_PP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  Higher
debug levels increase the verbosity of the output.

Example:
export SANE_DEBUG_PLUSTEK_PP=10

.SH "SEE ALSO"
.BR sane (7),
.br
.I @DOCDIR@/plustek/Plustek-PARPORT.changes
.br
.I http://www.gjaeger.de/scanner/plustek_pp/

.SH "CONTACT AND BUG-REPORTS"
Please send any information and bug-reports to:
.br
.B SANE Mailing List
.PP
Additional info and hints can be obtained from our
.br
Mailing-List archive at:
.br
.B http://www.sane-project.org/mailing-lists.html
.PP
or directly from the projects' homepage at:
.br
.B http://www.gjaeger.de/scanner/plustek_pp/
.PP
To obtain debug messages from the backend, please set the
environment-variable
.I SANE_DEBUG_PLUSTEK_PP
before calling your favorite scan-frontend (i.e. xscanimage).
.br
.B i.e.: export SANE_DEBUG_PLUSTEK_PP=20 ; xscanimage
.PP
The value controls the verbosity of the backend.
.PP

.SH "KNOWN BUGS & RESTRICTIONS"
.PP
.br
* The Halftoning works, but the quality is poor
.br
* Printers (especially HP models) will start to
.br
  print during scanning. This in fact is a problem
.br
  to other printers too, using bidirectional protocol
.br
  (see www.plustek.com (TAIWAN) page for further details)
.br
* The driver does not support these manic scalings up
.br
  to 16 times the physical resolution. The only scaling
.br
  is done on resolutions between the physical resolution
.br
  of the CDD-sensor and the stepper motor i.e. you have a
.br
  600x1200 dpi scanner and you are scanning using 800dpi,
.br
  so scaling is necesary, because the sensor only delivers
.br
  600dpi but the motor is capable to perform 800dpi steps.
.br
* On some devices, the pictures seems to be bluished
.PP
ASIC 98001 based models:
.br
* The 300dpi transparency and negative mode does not work
.br
  correctly.
.br
* There is currently no way to distinguish a model with
.br
  and without transpareny unit.
.br
* The scanned images seem to be too dark (P9636T)
.PP
ASIC 96003/1 based models:
.br
* 30bit mode is currently not supported.
.br
* On low-end systems and under heavy system load, the
.br
  driver will loose data, this might causes the sensor
.br
  to hit the scan-bed and/or the picture is corrupted.
.br
* The scanspeed on 600x1200 dpi models is slow.
.br
* The scanquality of the A3I is poor
.br
