#!/usr/bin/env qjscmd

// Populates the sidebar listview
function setup_sidebar( special, qt, all )
{
    var qobjects = Factory.constructors().sort();

    for ( var i=0; i < qobjects.length ; i++ ) {
	all.insertItem( qobjects[i] );

	if ( /^Q/.test(qobjects[i]) )
	    qt.insertItem( qobjects[i] );
	else
	    special.insertItem( qobjects[i] );
    }
}

//
// Main
//

// Create the UI
var mw = new QVBox();
var split = new QSplitter( mw );

side = new QTabWidget( split, 'sidebar' );
view = new QTabWidget( split, 'mainview' );

// Load the view
js = new QTextEdit( view, 'js' );
js.setReadOnly( true );

view.addTab( js, '&Javascript' );

view.set_class = function( clazz )
{
   clazz = clazz.replace( '^[^QK]*', '' );

   // JS docs
   var s = '';

   s = s + '<html>';
   s = s + '<body>';
   s = s + '<h1>' + clazz + '</h1>';

   try {
     var obj = eval('new '+clazz+'()'); 
     s = s + dump(obj);
   }
   catch ( err ) {
     s = s + '<font color="red">Error dumping object: ' + err + '</font>';
   }

   s = s + '</body>';
   s = s + '</html>';

   js.text = s;
}

view.setup = function()
{
  // JS docs
  var s = '';
  s = s + '<html>';
  s = s + '<body>';
  s = s + '<h1>Script Reference</h1>';
  s = s + '</body>';
  s = s + '</html>';

   js.text = s;
}

// Setup the sidebar
specialside = new QListBox( side, 'specialsidebar' );
qtside = new QListBox( side, 'qtsidebar' );
allside = new QListBox( side, 'allsidebar' );

side.addTab( specialside, '&Special' );
side.addTab( qtside, '&Qt' );
side.addTab( allside, '&All' );

setup_sidebar( specialside, qtside, allside );

qtside.connect( qtside, 'highlighted(const QString&)', view, 'set_class' );
specialside.connect( specialside, 'highlighted(const QString&)', view, 'set_class' );
allside.connect( allside, 'highlighted(const QString&)', view, 'set_class' );

//
// Show the window
//

side.maximumWidth = 250;
mw.resize( 800, 550 );

mw.show();

//
// Connect together
//
view.setup();

application.exec();

