Summary:	An X Window System image editing or paint program
Name:		xpaint
Version:	2.7.0
Release:	1mdk
License:        MIT
Group:		Graphics
BuildRequires: XFree86-devel xpm-devel libjpeg-devel libpng-devel libtiff-devel zlib-devel bison
Source0:	http://prdownloads.sourceforge.net/sf-xpaint/xpaint-%{version}.tar.bz2
Source1:	icons-%{name}.tar.bz2
Packager:	Stew Benedict <sbenedict@mandrakesoft.com>
URL:            https://sourceforge.net/projects/sf-xpaint
BuildRoot:	%{_tmppath}/xpaint-root

%description
XPaint is an X Window System color image editing program which supports
most standard paint program options.  XPaint also supports advanced
features like image processing algorithms and layers. XPaint allows you
to edit multiple images simultaneously and supports a variety of image
formats, including PPM, XBM, TIFF, JPEG, etc.

Install the xpaint package if you need a paint program for X which is
relatively easy to use - and use "The Gimp" for more professional work.

Xpaint is now based on the Xaw95 widget set for a nicer look, and it
also adds a number of new editing features, such as user defined filters
and layers. Some examples of filter and layer codes are included.

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q

%build
xmkmf -a
perl -p -i -e "s|CXXDEBUGFLAGS = .*|CXXDEBUGFLAGS = $RPM_OPT_FLAGS|" Makefile
perl -p -i -e "s|CDEBUGFLAGS = .*|CDEBUGFLAGS = $RPM_OPT_FLAGS|" Makefile
make xaw95static CDEBUGFLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT

make \
	DESTDIR=$RPM_BUILD_ROOT \
	BINDIR=%{_prefix}/X11R6/bin \
	MANDIR=%{_prefix}/X11R6/man/man1 install install.man

# (sb) fix the include path in the built in scripting filter examples
#perl -pi -e "s|$RPM_BUILD_ROOT||g" $RPM_BUILD_ROOT%{_datadir}/xpaint/filters/*.c


mkdir -p $RPM_BUILD_ROOT%{_menudir}
#mdk menu entry
cat << EOF > $RPM_BUILD_ROOT%{_menudir}/%{name} 
?package(xpaint):needs="X11" \
section="Multimedia/Graphics" \
title="Xpaint" \
longtitle="Paint program" \
command="/usr/X11R6/bin/xpaint" \
icon="xpaint.png"
EOF

#mdk icon
install -d $RPM_BUILD_ROOT%{_iconsdir}
tar jxf %{SOURCE1} -C $RPM_BUILD_ROOT%{_iconsdir}

%post
%update_menus


%postun
%clean_menus

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog README README.PNG TODO Doc
%{_prefix}/X11R6/bin/xpaint
%{_prefix}/X11R6/lib/X11/app-defaults/XPaint*
%{_prefix}/X11R6/man/man1/xpaint.1x*
%{_datadir}/xpaint/c_scripts/*
%{_datadir}/xpaint/help/*
%{_datadir}/xpaint/messages/*
%{_datadir}/xpaint/include/*
%config(noreplace) %{_sysconfdir}/X11/app-defaults/XPaint*


%{_menudir}/%{name}
%{_iconsdir}/*.png
%{_iconsdir}/*/*.png

%changelog
* Fri Apr  4 2003 Stew Benedict <sbenedict@mandrakesoft.com> 2.6.9-1mdk
- 2.6.9, new URL, Source tag 
- some new features finally, add patch1 to fix make install

* Mon Dec 30 2002 Stew Benedict <sbenedict@mandrakesoft.com> 2.6.2-2mdk
- rebuild for new glibc/rpm, add patch1 for errno

* Sat Nov 16 2002 Stew Benedict <sbenedict@mandrakesoft.com> 2.6.2-1mdk
- new version, add installed but unpackaged file, icons->png

* Fri Oct 19 2001 Sebastien Dupont <sdupont@mandrakesoft.com> 2.6.1-2mdk
- License
- srcs permissions
- remove patchs: xpaint-2.4.7-config.patch & xpaint-2.4.7-glibc.patch.

* Sun May 27 2001  Daouda Lo <daouda@mandrakesoft.com> 2.6.1-1mdk
- release 2.6.1
- stop Nono complains.
- cleanups

* Tue Oct 03 2000 Daouda Lo <daouda@mandrakesoft.com> 2.6.0-2mdk
- icons should be transparent
- let spec helper do its jobs
- menu entry in the body of the spec
- more macroz..

* Sun Aug 27 2000 Geoffrey Lee <snailtalk@mandrakesoft.com> 2.6.0-1mdk
- new and shiny version.

* Tue Aug 08 2000 Frederic Lepied <flepied@mandrakesoft.com> 2.4.9-16mdk
- automatically added BuildRequires

* Mon May 15 2000 David BAUDENS <baudens@mandrakesoft.com> 2.4-9-15mdk
- Fix build for i486
- Use %%{_tmppath} for BuildRoot

* Wed May 03 2000 dam's <damien@mandrakesoft.com> 2.4.9-14mdk
- Corrected icons.

* Tue Apr 18 2000 dam's <damien@mandrakesoft.com> 2.4.9-13mdk
- Convert gif icon to xpm.

* Mon Apr 17 2000 dam's <damien@mandrakesoft.com> 2.4.9-12mdk
- Added menu entry.

* Mon Mar 27 2000 dam's <damien@mandrakesoft.com> 2.4.9-11mdk
- Release.

* Tue Nov 02 1999 Pablo Saratxaga <pablo@mandrakesoft.com>
- corrected status of resource file

* Thu May 06 1999 Bernhard Rosenkraenzer <bero@mandrakesoft.com>
- Mandrake adaptions
- handle RPM_OPT_FLAGS

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 8)

* Thu Dec 17 1998 Michael Maher <mike@redhat.com>
- built package for 6.0

* Mon Aug  3 1998 Jeff Johnson <jbj@redhat.com>
- build root.

* Tue Jun 09 1998 Mike Wangsmo <wanger@redhat.com>
- changed the docs from being %config files.

* Fri May 01 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Thu Apr 16 1998 Erik Troan <ewt@redhat.com>
- built against libpng 1.0

* Fri Oct 24 1997 Marc Ewing <marc@redhat.com>
- new release
- wmconfig

* Wed Oct 15 1997 Erik Troan <ewt@redhat.com>
- build against new libpng

* Thu Jul 31 1997 Erik Troan <ewt@redhat.com>
- built against glibc

* Tue Mar 25 1997 Erik Troan <ewt@redhat.com>
- "make install.man" places man page in wrong location
