/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2003 by Stanislav Visnovsky
                            <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA  02111-1307, USA.

**************************************************************************** */
#ifndef KBABELDATATOOL_H
#define KBABELDATATOOL_H

#include <kdatatool.h>

namespace KBabel
{

/**
 * This class represents a base class for a KBabel @ref KDataTool.
 * It supports automatic settings management.
 *
 * @short This class represents a base class for a KBabel data tool.
 */                                                                              
class KBabelDataTool: public KDataTool
{
    Q_OBJECT
    
protected:
    KBabelDataTool( QObject* parent, const char* name ) : KDataTool( parent, name ) {}
public slots:
    /** The only method to be redefined in inherited classes.
     *  This method is called everytime the settings are changed.
     *  @param project is ID of the project, for which the settings changed.
     */
    virtual void settingsChanged(const QString &project) = 0;
};

}

#endif // KBABELDATATOOL_H
