/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#ifndef MARKPATTERNDIALOG_H
#define MARKPATTERNDIALOG_H

#include <kdialogbase.h>

class KCompletion;

class MarkPatternWidget;

class MarkPatternDialog : public KDialogBase
{
  Q_OBJECT
  
  public:
    MarkPatternDialog(QWidget * parent, const char * name = 0);
    
    QString pattern( );
    bool isCaseSensitive( );
    bool useRegExp( );
    bool includeTemplates( );
    
    void setMode(bool markMode);

  protected:
    virtual void accept( );
    void restoreSettings( );
    void saveSettings( );
    
  protected slots:
    void slotComboTextChanged(const QString& text);
    void slotRegexpButtonClicked( );
    
  private:
    MarkPatternWidget * mainWidget;
    QDialog * regexpEditDialog;
    
    QStringList patternList;
    
    KCompletion * comboCompletion;
};

#endif // MARKPATTERNDIALOG_H
