/***************************************************************************
                          QtSupport.h  -  description
                             -------------------
    begin                : Wed Mar 29 2000
    copyright            : (C) 2000 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QTSUPPORT_H
#define QTSUPPORT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSDate.h>
#include <Foundation/NSArray.h>

#include <qtc/qtc_types.h>

@class DOMString;

/**
  *@author Richard Dale
  */

/**
 An interface for getting and setting an instance variable
 '_qt', which holds a pointer to a C++ instance being wrapped.
 The pointer can be passed to QtC library function calls. For
 example, 'qt_QObject_dumpObjectTree([self qt])'.

 @short An interface for getting and setting '_qt', holding a Qt C++ pointer.
*/
@protocol QtSupport
/** Return a pointer to a C++ instance for use with QtC library function calls */
- (void *) qt;
/**
   Set the '_qt' instance variable to a pointer to a C++ instance. This should
   be called in the initialization method for the class.
  */
- setQt: (void *) qt;

	/** C++ instances are deleted in a - dealloc method iff 'allocatedInObjcWorld' is true. */
- (BOOL) allocatedInObjcWorld;
- setAllocatedInObjcWorld: (BOOL) yn;
@end

@interface QtSupport : NSObject
+ setObject: anId forQtKey: (void *) qt;
+ removeQtKey: (void *) qt;
+ objectForQtKey: (void *) qt withClass: (Class) objcClass;
+ objectForQtKey: (void *) qt withClass: (Class) objcClass allocatedInObjcWorld: (BOOL) yn;

/**
   Connect a sender/signal to a receiver/slot. If the signal ends with ")", it is considered to
   originate from a C++ member function, and a slot ending with ")" is considered to have
   a member function as target. Otherwise, the signal or slot should be an Objective-C style method name.
   @param sender The sender Objective-C instance
   @param signal A string such as "activated(int)" for C++ signals or "activated:" for Objective-C signals
   @param receiver The receiver Objective-C instance
   @param slot A string such as "slotShowHelp()" for C++ slots or "slotShowHelp" for Objective-C slots	
  */
+ (BOOL) connect: sender signal: (NSString *) signal receiver: receiver slot: (NSString *) slot;
+ (BOOL) disconnect: sender signal: (NSString *) signal receiver: receiver slot: (NSString *) slot;

/** Creates a QtC Signal for an Objective-C sender/signal combination, and adds it to the qtSignalDictionary  */
+ (void *) signalIdForSender:  sender signal: (NSString *) signal;

/** Creates a QtC Slot for an Objective-C receiver/slot combination as target  */
+ (int) slotIdForReceiver: receiver slot: (NSString *) member;

/** Emit a signal with no parameter */
+ sender: sender emit: (NSString *) signal;

/** Emit a signal with an int parameter */
+ sender: sender emit: (NSString *) signal intValue: (int) value;

/** Emit a signal with a void * parameter corresponding to an Objective-C instance */
+ sender: sender emit: (NSString *) signal value: value;

@end

/** Convenience methods for converting between NSDate and Qt dates and times */
@interface NSDate (QtSupport)
- initWithQDate: (qt_QDate *) qdate;
- initWithQTime: (qt_QTime *) qtime;
- initWithQDateTime: (qt_QDateTime *) qdatetime;
- (qt_QDate *) toQDate: (qt_QDate **) qdate;
- (qt_QTime *) toQTime: (qt_QTime **) qtime;
- (qt_QDateTime *) toQDateTime: (qt_QDateTime **) qdatetime;
@end

@interface NSString (QtSupport)
- (qt_QString *) toQString: (qt_QString **) string;
- (qt_QCString *) toQCString: (qt_QCString **) string;
+ (NSString *) fromQString: (qt_QString *) string;
+ (NSString *) fromQCString: (qt_QCString *) string;
@end

/** Convenience methods for converting NSArrays to Qt string lists */
@interface NSArray (QtSupport)
- (qt_QStrList *) toQStrList: (qt_QStrList **) strlist;
- (qt_QStringList *) toQStringList: (qt_QStringList **) strlist;
@end

/** Convenience methods for creating NSMutableArrays from Qt lists */
@interface NSMutableArray (QtSupport)
+ (NSArray *) arrayWithQStrList: (qt_QStrList *) strlist;
+ (NSArray *) arrayWithQStringList: (qt_QStringList *) stringlist;
+ (NSArray *) arrayWithQWidgetList: (qt_QWidgetList *) widgetlist;
+ (NSArray *) arrayWithQPointArray: (qt_QPointArray *) pointArray;
+ (NSArray *) arrayWithQDomNodeList: (qt_QDomNodeList *) nodelist;
+ (NSArray *) arrayWithQObjectList: (qt_QObjectList *) objectlist;
+ (NSArray *) arrayWithQFileInfoList: (qt_QFileInfoList *) infolist;
@end

#endif
