/***************************************************************************
                            QDomNode.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QDOMNODE_H
#define QDOMNODE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>

#include <qtobjc/QtSupport.h>
#include <qtobjc/QDomNodeList.h>
#include <qtobjc/QDomNamedNodeMap.h>

@class QDomElement;
@class QDomDocumentType;
@class QDomDocumentFragment;
@class QDomDocument;
@class QDomAttr;
@class QDomEntityReference;
@class QDomText;
@class QDomEntity;
@class QDomNotation;
@class QDomProcessingInstruction;
@class QDomCharacterData;
@class QDomComment;
@class QDomTextStream;
@class QDomCDATASection;
@class QTextStream;

@class QDomNodePrivate; 

@interface  QDomNode : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;
- (QDomNode*) insertBefore: (QDomNode*)newChild refChild: (QDomNode*)refChild;
- (QDomNode*) insertAfter: (QDomNode*)newChild refChild: (QDomNode*)refChild;
- (QDomNode*) replaceChild: (QDomNode*)newChild oldChild: (QDomNode*)oldChild;
- (QDomNode*) removeChild: (QDomNode*)oldChild;
- (QDomNode*) appendChild: (QDomNode*)newChild;
- (BOOL) hasChildNodes;
- (QDomNode*) cloneNode: (BOOL)deep;
- (QDomNode*) cloneNode;
- normalize;
- (BOOL) isSupported: (NSString *)feature version: (NSString *)version;
- (NSString *) nodeName;
- (int) nodeType;
- (QDomNode*) parentNode;
- (NSArray *) childNodes;
- (QDomNode*) firstChild;
- (QDomNode*) lastChild;
- (QDomNode*) previousSibling;
- (QDomNode*) nextSibling;
- (QDomNamedNodeMap*) attributes;
- (QDomDocument*) ownerDocument;
- (NSString *) namespaceURI;
- (NSString *) localName;
- (BOOL) hasAttributes;
- (NSString *) nodeValue;
- setNodeValue: (NSString *)arg1;
- (NSString *) prefix;
- setPrefix: (NSString *)pre;
- (BOOL) isAttr;
- (BOOL) isCDATASection;
- (BOOL) isDocumentFragment;
- (BOOL) isDocument;
- (BOOL) isDocumentType;
- (BOOL) isElement;
- (BOOL) isEntityReference;
- (BOOL) isText;
- (BOOL) isEntity;
- (BOOL) isNotation;
- (BOOL) isProcessingInstruction;
- (BOOL) isCharacterData;
- (BOOL) isComment;

/** 
 Shortcut to avoid dealing with QDomNodeList
 all the time.
     
*/
- (QDomNode*) namedItem: (NSString *)name;
- (BOOL) isNull;
- clear;
- (QDomAttr*) toAttr;
- (QDomCDATASection*) toCDATASection;
- (QDomDocumentFragment*) toDocumentFragment;
- (QDomDocument*) toDocument;
- (QDomDocumentType*) toDocumentType;
- (QDomElement*) toElement;
- (QDomEntityReference*) toEntityReference;
- (QDomText*) toText;
- (QDomEntity*) toEntity;
- (QDomNotation*) toNotation;
- (QDomProcessingInstruction*) toProcessingInstruction;
- (QDomCharacterData*) toCharacterData;
- (QDomComment*) toComment;
- save: (QTextStream*)arg1 int: (int)arg2;
//- initWithDomNodePrivate: (QDomNodePrivate*)arg1;
+ (int) ElementNode;
+ (int) AttributeNode;
+ (int) TextNode;
+ (int) CDATASectionNode;
+ (int) EntityReferenceNode;
+ (int) EntityNode;
+ (int) ProcessingInstructionNode;
+ (int) CommentNode;
+ (int) DocumentNode;
+ (int) DocumentTypeNode;
+ (int) DocumentFragmentNode;
+ (int) NotationNode;
+ (int) BaseNode;
+ (int) CharacterDataNode;
@end

#endif
