/***************************************************************************
                            SynthOut.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef SYNTHOUT_H
#define SYNTHOUT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/MidiOut.h>

/**

 Synth (AWE) device output class . SynthOut is used to send MIDI events to
 a general synthesizer, such as AWE synth.

 SynthOut inherits @ref MidiOut and supports the same simple API.

 The preferred way to use this class is by selecting a synth (or AWE)
 device with @ref -[MidiManager setDefaultDevice], and use a 
 @ref MidiManager object.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to AWE synthesizers.
*/
@interface SynthOut : MidiOut 

/** 
 Constructor. See @ref -[MidiOut MidiOut] for more information.
     
*/
- initWithInt: (int)d;
- init;

/** 
 Destructor.
     
*/
- (void) dealloc;

/** 
 See @ref -[MidiOut openDev]
     
*/
- openDev: (int)sqfd;

/** 
 See @ref -[MidiOut closeDev]
     
*/
- closeDev;

/** 
 See @ref -[MidiOut initDev]
     
*/
- initDev;

/** 
 See @ref -[MidiOut noteOn]
     
*/
- noteOn: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut noteOff]
     
*/
- noteOff: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut keyPressure]
     
*/
- keyPressure: (unsigned char)chn note: (unsigned char)note vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut chnPatchChange]
     
*/
- chnPatchChange: (unsigned char)chn patch: (unsigned char)patch;

/** 
 See @ref -[MidiOut chnPressure]
     
*/
- chnPressure: (unsigned char)chn vel: (unsigned char)vel;

/** 
 See @ref -[MidiOut chnPitchBender]
     
*/
- chnPitchBender: (unsigned char)chn lsb: (unsigned char)lsb msb: (unsigned char)msb;

/** 
 See @ref -[MidiOut chnController]
     
*/
- chnController: (unsigned char)chn ctl: (unsigned char)ctl v: (unsigned char)v;

/** 
 It's an empty function, as AWE devices don't support System Exclusive
 messages
     
*/
- sysex: (unsigned char*)data size: (unsigned long)size;
@end

#endif
