/***************************************************************************
                            KSqueezedTextLabel.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSQUEEZEDTEXTLABEL_H
#define KSQUEEZEDTEXTLABEL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QLabel.h>

/**

 A label class that squeezes its text into the label

 If the text is too long to fit into the label it is divided into
 remaining left and right parts which are separated by three dots.

 Example:
 http://www.kde.org/documentation/index.html could be squeezed to
 http://www.kde...ion/index.html

 
 @author Ronny Standtke <Ronny.Standtke@gmx.de>

 @version $Id: KSqueezedTextLabel.h,v 1.3 2002/03/15 02:12:23 rdale Exp $

 @short A replacement for QLabel that squeezes its text.
*/
@interface KSqueezedTextLabel : QLabel 

/** 
 Default constructor.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;
- initWithText: (NSString *)text parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)text parent: (QWidget *)parent ;
- (QSize*) minimumSizeHint;
- setText: (NSString *)arg1;

/** 
 does the dirty work
   
*/
- squeezeTextToLabel;
@end

/** Override these methods in subclasses of KSqueezedTextLabel to customise event handling behaviour */
@protocol KSqueezedTextLabelEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/** 
 used when widget is resized
   
*/
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
