//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QDir;
import org.kde.qt.QtSupport;

/**

 The KTempDir class creates a unique directory for temporary use.
 This is especially useful if you need to create a directory in a world
 writable directory like /tmp without being vulnerable to so called
 symlink attacks.
 KDE applications, however, shouldn't create files or directories in /tmp in the first 
 place but use the "tmp" resource instead. The standard KTempDir
 constructor will do that by default.
 To create a temporary directory that starts with a certain name
 in the "tmp" resource, one should use:
 KTempDir(locateLocal("tmp", prefix));
 KTempFile does not create any missing directories, but locateLocal() does.
 See also KStandardDirs
		@author Joseph Wenninger <jowenn@kde.org>
 
		@short    The KTempDir class creates a unique directory for temporary use.

*/
public class KTempDir implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KTempDir(Class dummy){}

	/**	
		 Creates a temporary directory with the name:
		  \p \<directoryPrefix\>\<six letters\>
			 The default <pre>directoryPrefix</pre> is "$KDEHOME/tmp-$HOST/appname"
			@param directoryPrefix the prefix of the file name, or
		        null for the default value 
			@param mode the file permissions,
		 almost always in octal. The first digit selects permissions for
		 the user who owns the file: read (4), write (2), and execute
		 (1); the second selects permissions for other users in the
		 file's group, with the same values; and the fourth for other
		 users not in the file's group, with the same values. 
				@short    Creates a temporary directory with the name:   \p \<directoryPrefix\>\<six letters\>
	*/
	public KTempDir(String directoryPrefix, int mode) {
		newKTempDir(directoryPrefix,mode);
	}
	private native void newKTempDir(String directoryPrefix, int mode);
	public KTempDir(String directoryPrefix) {
		newKTempDir(directoryPrefix);
	}
	private native void newKTempDir(String directoryPrefix);
	public KTempDir() {
		newKTempDir();
	}
	private native void newKTempDir();
	/**	
		 Turn automatic deletion on or off.
		 Automatic deletion is off by default.
			@param autoDelete true to turn automatic deletion on
				@short    Turn automatic deletion on or off.
	*/
	public native void setAutoDelete(boolean autoDelete);
	/**	
		 Returns the status of the directory creation  based on errno. (see errno.h) 
		 0 means OK.
			 You should check the status after object creation to check 
		 whether a directory could be created in the first place.
				@return the errno status, 0 means ok

		@short    Returns the status of the directory creation  based on errno.
	*/
	public native int status();
	/**	
		 Returns the full path and name of the directory.
				@return The name of the file, or null if creating the
         directory has failed or the directory has been unlinked

		@short    Returns the full path and name of the directory.
	*/
	public native String name();
	/**	
		 Returns the QDir of the temporary directory.
				@return QDir directory information of the directory or 0 if their is no managed directory
 The caller has to free the pointer open for writing to the 

		@short    Returns the QDir  of the temporary directory.
	*/
	public native QDir qDir();
	/**	
		 Deletes the directory recursively
				@short    Deletes the directory recursively
	*/
	public native void unlink();
	/**	
				@return true if a temporary directory has successfully been created and not been unlinked yet
    
		@short
	*/
	public native boolean existing();
	public KTempDir(KTempDir arg1) {
		newKTempDir(arg1);
	}
	private native void newKTempDir(KTempDir arg1);
	protected native boolean create(String directoryPrefix, int mode);
	protected native void setError(int error);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
