/***************************************************************************
                            kde_ReadWritePart.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_READWRITEPART
#define KDE_READWRITEPART

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Base class for an "editor" part.

 This class handles network transparency for you.
 Anything that can open a URL, allow modifications, and save
 (to the same URL or a different one).

 A read-write part can be set to read-only mode, using @ref setReadWrite().

 Part writers :
 Any part inheriting ReadWritePart should check @ref isReadWrite
 before allowing any action that modifies the part.
 The part probably wants to reimplement @ref setReadWrite, disable those
 actions. Don't forget to call the parent @ref setReadWrite.
 
 @short *
 Base class for an "editor" part.
*/

/** *
 Destructor
 Applications using a ReadWritePart should make sure, before
 destroying it, to call @ref #closeURL().
 In @ref KMainWindow::queryClose(), for instance, they should allow
 closing only if the return value of @ref #closeURL() was true.
 This allows to cancel.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_del_ReadWritePart( kde_ReadWritePart* p );

/** *

*/
int kde_ReadWritePart_isReadWrite(kde_ReadWritePart* instPointer);

/** *
 Changes the behaviour of this part to readonly or readwrite.

*/
void kde_ReadWritePart_setReadWrite(kde_ReadWritePart* instPointer,int readwrite);

/** *

*/
int kde_ReadWritePart_isModified(kde_ReadWritePart* instPointer);

/** *
 Called when closing the current url (e.g. document), for instance
 when switching to another url (note that @ref openURL() calls it
 automatically in this case).
 If the current URL is not fully loaded yet, aborts loading.
 Reimplemented from ReadOnlyPart, to handle modified parts
 (and suggest saving in this case, with yes/no/cancel).

*/
int kde_ReadWritePart_closeURL(kde_ReadWritePart* instPointer);

/** *
 Save the file to a new location.

 Calls @ref save(), no need to reimplement
   
*/
int kde_ReadWritePart_saveAs(kde_ReadWritePart* instPointer,kde_KURL* url);

/** *
  Sets the modified flag of the part.
   
*/
void kde_ReadWritePart_setModified(kde_ReadWritePart* instPointer,int modified);

/** *
 Call @ref setModified() whenever the contents get modified.
 This is a slot for convenience, so that you can connect it
 to a signal, like textChanged().
   
*/
void kde_ReadWritePart_setModified1(kde_ReadWritePart* instPointer);

/** *
 Save the file in the location from which it was opened.
 You can connect this to the "save" action.
 Calls @ref saveFile() and @ref saveToURL(), no need to reimplement.
   
*/
int kde_ReadWritePart_save(kde_ReadWritePart* instPointer);

#ifdef __cplusplus
}
#endif
#endif
