/***************************************************************************
                            kde_KGlobalSettings.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KGLOBALSETTINGS
#define KDE_KGLOBALSETTINGS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Access the KDE global configuration.

 @author David Faure <faure@kde.org>

 @version $Id: kde_KGlobalSettings.h,v 1.7 2004/01/09 14:29:31 domi Exp $
 @short *
 Access the KDE global configuration.
*/
#define KGLOBALSETTINGS_Disable	0
#define KGLOBALSETTINGS_ApplicationLevel	0
#define KGLOBALSETTINGS_Enable	1

/*** No completion is used.*/
#define KGLOBALSETTINGS_CompletionNone	1
/*** Text is automatically filled in whenever possible.*/
#define KGLOBALSETTINGS_CompletionAuto	2
/*** Same as automatic except shortest match is used for completion.*/
#define KGLOBALSETTINGS_CompletionMan	3
/*** Complete text much in the same way as a typical *nix shell would.*/
#define KGLOBALSETTINGS_CompletionShell	4
/*** Lists all possible matches in a popup list-box to choose from.*/
#define KGLOBALSETTINGS_CompletionPopup	5
/*** Lists all possible matches in a popup list-box to choose from and
 * automatically fill the result whenever possible.*/
#define KGLOBALSETTINGS_CompletionPopupAuto 6

/** *
 Returns a threshold in pixels for drag & drop operations.
 As long as the mouse movement has not exceeded this number
 of pixels in either X or Y direction no drag operation may
 be started. This prevents spurious drags when the user intended
 to click on something but moved the mouse a bit while doing so.

 For this to work you must save the position of the mouse (oldPos)
 in the @ref QWidget::mousePressEvent().
 When the position of the mouse (newPos)
 in a  @ref QWidget::mouseMoveEvent() exceeds this threshold
 you may start a drag
 which should originate from oldPos.

 Example code:
 <pre>
 void KColorCells::mousePressEvent( QMouseEvent *e )
 {
    mOldPos = e->pos();
 }

 void KColorCells::mouseMoveEvent( QMouseEvent *e )
 {
    if( !(e->state() && LeftButton)) return;

    int delay = KGlobalSettings::dndEventDelay();
    QPoint newPos = e->pos();
    if(newPos.x() > mOldPos.x()+delay || newPos.x() < mOldPos.x()-delay ||
       newPos.y() > mOldPos.y()+delay || newPos.y() < mOldPos.y()-delay)
    {
       // Drag color object
       int cell = posToCell(mOldPos); // Find color at mOldPos
       if ((cell != -1) && colors[cell].isValid())
       {
          KColorDrag *d = KColorDrag::makeDrag( colors[cell], this);
          d->dragCopy();
       }
    }
 }
 </pre>

*/
#ifdef __cplusplus
extern   "C" {
#endif
int kde_KGlobalSettings_dndEventDelay( );

/** *
 Returns whether KDE runs in single (default) or double click
 mode.
 see http://developer.kde.org/documentation/standards/kde/style/mouse/index.html

*/
int kde_KGlobalSettings_singleClick( );

/** *
 Returns whether tear-off handles are inserted in @ref KPopupMenus.

*/
int kde_KGlobalSettings_insertTearOffHandle( );

/** *
 Checks whether the cursor changes over icons.

*/
int kde_KGlobalSettings_changeCursorOverIcon( );

/** *
 Checks whether to show feedback when in item (specifically an
 icon) is activated.

*/
int kde_KGlobalSettings_visualActivate( );

/** *
 Returns the speed of the visual activation feedback.

*/
unsigned int kde_KGlobalSettings_visualActivateSpeed( );

/** *
 Returns the KDE setting for the auto-select option.

*/
int kde_KGlobalSettings_autoSelectDelay( );

/** *
 Returns the KDE setting for the shortcut key to open
 context menus.

*/
int kde_KGlobalSettings_contextMenuKey( );

/** *
 Returns the KDE setting for context menus.

*/
int kde_KGlobalSettings_showContextMenusOnPress( );

/** *
 Returns the preferred completion mode setting.

*/
int kde_KGlobalSettings_completionMode( );

/** *
 This returns the current mouse settings.

*/

/** *
 The path to the desktop directory of the current user.

*/
qt_QString * kde_KGlobalSettings_desktopPath( );

/** *
 The path to the autostart directory of the current user.

*/
qt_QString * kde_KGlobalSettings_autostartPath( );

/** *
 The path to the trash directory of the current user.

*/
qt_QString * kde_KGlobalSettings_trashPath( );

/** *
 The path where documents are stored of the current user.

*/
qt_QString * kde_KGlobalSettings_documentPath( );

/** *
 The default color to use when highlighting toolbar buttons.

*/
qt_QColor * kde_KGlobalSettings_toolBarHighlightColor( );

/** *
 The default color to use for inactive titles.

*/
qt_QColor * kde_KGlobalSettings_inactiveTitleColor( );

/** *
 The default color to use for inactive texts.

*/
qt_QColor * kde_KGlobalSettings_inactiveTextColor( );

/** *
 The default color to use for active titles.

*/
qt_QColor * kde_KGlobalSettings_activeTitleColor( );

/** *
 The default color to use for active texts.

*/
qt_QColor * kde_KGlobalSettings_activeTextColor( );

/** *
 Returns the contrast for borders.

*/
int kde_KGlobalSettings_contrast( );

/** *
 Returns the default base (background) color.

*/
qt_QColor * kde_KGlobalSettings_baseColor( );

/** *
 Returns the default text color.

*/
qt_QColor * kde_KGlobalSettings_textColor( );

/** *
 Returns the default link color.

*/
qt_QColor * kde_KGlobalSettings_linkColor( );

/** *
 Returns the default color for visited links.

*/
qt_QColor * kde_KGlobalSettings_visitedLinkColor( );

/** *
 Returns the default color for highlighted text.

*/
qt_QColor * kde_KGlobalSettings_highlightedTextColor( );

/** *
 Returns the default color for text highlights.

*/
qt_QColor * kde_KGlobalSettings_highlightColor( );

/** *
 Returns the alternate background color used by @ref KListView with
 @ref KListViewItem. Any other list that uses alternating background
 colors should use this too, to obey to the user's preferences. Returns
 an invalid color if the user doesn't want alternating backgrounds.

*/
qt_QColor * kde_KGlobalSettings_alternateBackgroundColor( );

/** *
 Calculates a color based on @p base to be used as alternating
 color for e.g. listviews.

*/
qt_QColor * kde_KGlobalSettings_calculateAlternateBackgroundColor( qt_QColor * base);

/** *
 Returns the default general font.

*/
qt_QFont * kde_KGlobalSettings_generalFont( );

/** *
 Returns the default fixed font.

*/
qt_QFont * kde_KGlobalSettings_fixedFont( );

/** *
 Returns the default toolbar font.

*/
qt_QFont * kde_KGlobalSettings_toolBarFont( );

/** *
 Returns the default menu font.

*/
qt_QFont * kde_KGlobalSettings_menuFont( );

/** *
 Returns the default window title font.

*/
qt_QFont * kde_KGlobalSettings_windowTitleFont( );

/** *
 Returns the default taskbar font.

*/
qt_QFont * kde_KGlobalSettings_taskbarFont( );

/** *
 Returns a font of approx. 48 pt. capable of showing @p text.

*/
qt_QFont * kde_KGlobalSettings_largeFont( qt_QString * text);

/** *
 Returns if the user specified multihead. In case the display
 has multiple screens, the return value of this function specifies
 if the user wants KDE to run on all of them or just on the primary

*/
int kde_KGlobalSettings_isMultiHead( );

/** *
 Typically, QScrollView derived classes can be scrolled fast by
 holding down the Ctrl-button during wheel-scrolling.
 But QTextEdit and derived classes perform zooming instead of fast
 scrolling.

 This value determines whether the user wants to zoom or scroll fast
 with Ctrl-wheelscroll.

*/
int kde_KGlobalSettings_wheelMouseZooms( );

#ifdef __cplusplus
}
#endif
#endif
