/***************************************************************************
                            kde_KFileMetaInfo.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILEMETAINFO
#define KDE_KFILEMETAINFO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 This is the class for objects that hold meta information about a file.
 The information is kept in form of a system of key/value pairs. See also
 @ref KFileMetaInfoItem.
 This information is retrieved from the file through a plugin system, and
 this class is the main interface to it.
 If you want to write your own plugin, have a look at @ref KFilePlugin.
 There are basically two different kinds of meta information: Fixed ones
 that the plugin knows about (e.g. an mp3 id3v1 tag has a well defined
 fixed list of fields), and variable keys that exist in mimetypes that
 support their own key/value system (comments in png files are of this type).
 Almost every file has fixed keys, but some also have variable keys.

 The groups and the What enum are not yet supported, but already added to
 the interface so that adding support doesn't break compatibility.

 
 @short *

*/
#define KFILEMETAINFO_Fastest	0x1
#define KFILEMETAINFO_DontCare	0x2
#define KFILEMETAINFO_TechnicalInfo	0x4
#define KFILEMETAINFO_ContentInfo	0x8
#define KFILEMETAINFO_ExtenedAttr	0x10
#define KFILEMETAINFO_Thumbnail	0x20
#define KFILEMETAINFO_Preferred	0x40
#define KFILEMETAINFO_Everything	0xffff

/** *
 The constructor.

 creating a KFileMetaInfo item through this will autoload the plugin
 belonging to the mimetype and try to get meta information about
 the specified file.

 If no info is available, you'll get an empty (not invalid) object.
 You can test for it with the @ref isEmpty() method.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KFileMetaInfo * kde_new_KFileMetaInfo(qt_QString * path, qt_QString * mimeType, unsigned int what);

/** *
 Default constructor. This will create an invalid object (see
 @ref isValid().

*/
kde_KFileMetaInfo * kde_new_KFileMetaInfo1();

/** *
 Copy constructor

*/
void kde_del_KFileMetaInfo( kde_KFileMetaInfo* p );

/** *

*/
qt_QStringList* kde_KFileMetaInfo_groups(kde_KFileMetaInfo* instPointer);
qt_QStringList* kde_KFileMetaInfo_supportedGroups(kde_KFileMetaInfo* instPointer);
qt_QStringList* kde_KFileMetaInfo_preferredGroups(kde_KFileMetaInfo* instPointer);
qt_QStringList* kde_KFileMetaInfo_preferredKeys(kde_KFileMetaInfo* instPointer);
qt_QStringList* kde_KFileMetaInfo_supportedKeys(kde_KFileMetaInfo* instPointer);

/** *

*/
qt_QStringList* kde_KFileMetaInfo_editableGroups(kde_KFileMetaInfo* instPointer);

/** *
 Try to add the specified group. This will only succeed if it is
 in the list of @ref editableGroups(). Note that all non-variable
 items that belong to this group are automatically added as empty
 item.
    
*/
int kde_KFileMetaInfo_addGroup(kde_KFileMetaInfo* instPointer,qt_QString * name);

/** *
 remove the specified group. This will only succeed if it is
 in the list of @ref editableGroups(). Beware that this also
 removes all the items in that group, so always ask the user
 before removing it!
    
*/
int kde_KFileMetaInfo_removeGroup(kde_KFileMetaInfo* instPointer,qt_QString * name);
qt_QStringList* kde_KFileMetaInfo_removedGroups(kde_KFileMetaInfo* instPointer);

/** *
 This method writes all pending changes of the meta info back to the file.
 If any items are marked as removed, they are really removed from the
 list. The info object as well as all items are updated.

*/
int kde_KFileMetaInfo_applyChanges(kde_KFileMetaInfo* instPointer);

/** *

*/
int kde_KFileMetaInfo_contains(kde_KFileMetaInfo* instPointer,qt_QString * key);

/** *

*/
int kde_KFileMetaInfo_containsGroup(kde_KFileMetaInfo* instPointer,qt_QString * key);
qt_QVariant * kde_KFileMetaInfo_value(kde_KFileMetaInfo* instPointer,qt_QString * key);

/** *

*/
int kde_KFileMetaInfo_isValid(kde_KFileMetaInfo* instPointer);

/** *

*/
int kde_KFileMetaInfo_isEmpty(kde_KFileMetaInfo* instPointer);
qt_QString * kde_KFileMetaInfo_mimeType(kde_KFileMetaInfo* instPointer);
qt_QString * kde_KFileMetaInfo_path(kde_KFileMetaInfo* instPointer);

/** *

*/
kde_KFilePlugin* kde_KFileMetaInfo_plugin(kde_KFileMetaInfo* instPointer);
void kde_KFileMetaInfo_ref(kde_KFileMetaInfo* instPointer);
void kde_KFileMetaInfo_deref(kde_KFileMetaInfo* instPointer);

#ifdef __cplusplus
}
#endif
#endif
